/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.util.ResourceExtUtils;

public class PrimeFacesResourceProcessor
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final String LIBRARY = "primefaces";

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        String theme;
        FacesContext context = event.getFacesContext();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        String themeParamValue = configuration.getTheme();
        if (themeParamValue != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "saga";
        }
        if (theme != null && !"none".equals(theme)) {
            ResourceExtUtils.addCssResource(context, "primefaces-" + theme, "theme.css");
        }
        if (configuration.isPrimeIconsEnabled()) {
            ResourceExtUtils.addCssResource(context, LIBRARY, "primeicons/primeicons.css");
        }
    }

    public void afterPhase(PhaseEvent event) {
    }
}

