/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.remotecommand;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.extensions.component.base.AbstractParameter;
import org.primefaces.extensions.component.parameters.AssignableParameter;
import org.primefaces.extensions.component.remotecommand.RemoteCommand;
import org.primefaces.extensions.util.ExtAjaxRequestBuilder;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentTraversalUtils;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        RemoteCommand command = (RemoteCommand)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId = command.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)command);
            if (command.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            ELContext elContext = context.getELContext();
            for (AssignableParameter param : command.getAssignableParameters()) {
                if (!param.isRendered()) continue;
                ValueExpression valueExpression = param.getAssignTo();
                String paramValue = (String)params.get(clientId + "_" + param.getName());
                Converter converter = param.getConverter();
                if (converter != null) {
                    Object convertedValue = converter.getAsObject(context, (UIComponent)param, paramValue);
                    valueExpression.setValue(elContext, convertedValue);
                    continue;
                }
                valueExpression.setValue(elContext, (Object)paramValue);
            }
            command.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIForm form = ComponentTraversalUtils.closestForm((UIComponent)component);
        if (form == null) {
            throw new FacesException("Component " + component.getClientId(context) + " must be enclosed in a form.");
        }
        ResponseWriter writer = context.getResponseWriter();
        RemoteCommand command = (RemoteCommand)component;
        String clientId = command.getClientId(context);
        List<AbstractParameter> parameters = command.getAllParameters();
        String name = command.getName();
        ExtAjaxRequestBuilder builder = ExtAjaxRequestBuilder.get(context);
        builder.init().source(clientId).form((AjaxSource)command, (UIComponent)command, form).process(component, command.getProcess()).update(component, command.getUpdate()).async(command.isAsync()).global(command.isGlobal()).partialSubmit(command.isPartialSubmit(), command.isPartialSubmitSet(), command.getPartialSubmitFilter()).resetValues(command.isResetValues(), command.isResetValuesSet()).ignoreAutoUpdate(command.isIgnoreAutoUpdate()).onstart(command.getOnstart()).onerror(command.getOnerror()).onsuccess(command.getOnsuccess()).oncomplete(command.getOncomplete()).delay(command.getDelay()).timeout(command.getTimeout());
        builder.params(clientId, parameters);
        String request = builder.build();
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("id", (Object)command.getClientId(), null);
        writer.write(name + " = function(");
        for (int i = 0; i < parameters.size(); ++i) {
            if (i != 0) {
                writer.write(",");
            }
            AbstractParameter param = parameters.get(i);
            writer.write(param.getName());
        }
        writer.write(") {");
        writer.write(request);
        writer.write("}");
        if (command.isAutoRun()) {
            writer.write(";$(function() {");
            writer.write(name + "();");
            writer.write("});");
        }
        writer.endElement("script");
    }
}

