/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timepicker;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.primefaces.component.api.AbstractPrimeHtmlInputText;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.BeforeShowEvent;
import org.primefaces.extensions.event.CloseEvent;
import org.primefaces.extensions.event.TimeSelectEvent;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="timepicker/timepicker.css"), @ResourceDependency(library="primefaces-extensions", name="timepicker/timepicker.js")})
public class TimePicker
extends AbstractPrimeHtmlInputText
implements Widget,
InputHolder {
    public static final String CONTAINER_CLASS = "pe-timepicker ui-widget ui-corner-all";
    public static final String INPUT_CLASS = "ui-inputfield ui-state-default ui-corner-all";
    public static final String UP_BUTTON_CLASS = "ui-spinner-button ui-spinner-up ui-corner-tr ui-button ui-widget ui-state-default";
    public static final String DOWN_BUTTON_CLASS = "ui-spinner-button ui-spinner-down ui-corner-br ui-button ui-widget ui-state-default";
    public static final String UP_ICON_CLASS = "ui-icon ui-icon-triangle-1-n";
    public static final String DOWN_ICON_CLASS = "ui-icon ui-icon-triangle-1-s";
    public static final String BUTTON_TRIGGER_CLASS = "pe-timepicker-trigger ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
    public static final String BUTTON_TRIGGER_ICON_CLASS = "ui-button-icon-left ui-icon ui-icon-clock";
    public static final String BUTTON_TRIGGER_TEXT_CLASS = "ui-button-text";
    public static final String TIME_MESSAGE_KEY = "jakarta.faces.converter.DateTimeConverter.TIME";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.TimePicker";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.TimePickerRenderer";
    private static final List<String> UNOBSTRUSIVE_EVENT_NAMES = LangUtils.unmodifiableList((Object[])new String[]{"beforeShow", "timeSelect", "close"});
    private static final Collection<String> EVENT_NAMES = LangUtils.concat((List[])new List[]{AbstractPrimeHtmlInputText.EVENT_NAMES, UNOBSTRUSIVE_EVENT_NAMES});
    private final Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();
    private Locale appropriateLocale;

    public TimePicker() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    public String getValidatableInputClientId() {
        return this.getInputClientId();
    }

    public String getLabelledBy() {
        return (String)this.getStateHelper().get((Serializable)((Object)"labelledby"));
    }

    public void setLabelledBy(String labelledBy) {
        this.getStateHelper().put((Serializable)((Object)"labelledby"), (Object)labelledBy);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public String getTimeSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeSeparator), (Object)":");
    }

    public void setTimeSeparator(String timeSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeSeparator), (Object)timeSeparator);
    }

    public boolean isShowPeriod() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showPeriod), (Object)false);
    }

    public void setShowPeriod(boolean showPeriod) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showPeriod), (Object)showPeriod);
    }

    public String getMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mode), (Object)"spinner");
    }

    public void setMode(String mode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mode), (Object)mode);
    }

    public String getDialogPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dialogPosition), (Object)"left top");
    }

    public void setDialogPosition(String dialogPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dialogPosition), (Object)dialogPosition);
    }

    public String getInputPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputPosition), (Object)"left bottom");
    }

    public void setInputPosition(String inputPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputPosition), (Object)inputPosition);
    }

    public int getStartHours() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.startHours), (Object)0);
    }

    public void setStartHours(int startHours) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.startHours), (Object)startHours);
    }

    public int getEndHours() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.endHours), (Object)23);
    }

    public void setEndHours(int endHours) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.endHours), (Object)endHours);
    }

    public int getStartMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.startMinutes), (Object)0);
    }

    public void setStartMinutes(int startMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.startMinutes), (Object)startMinutes);
    }

    public int getEndMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.endMinutes), (Object)55);
    }

    public void setEndMinutes(int endMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.endMinutes), (Object)endMinutes);
    }

    public int getIntervalMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.intervalMinutes), (Object)5);
    }

    public void setIntervalMinutes(int intervalMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.intervalMinutes), (Object)intervalMinutes);
    }

    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), (Object)4);
    }

    public void setRows(int rows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rows), (Object)rows);
    }

    public boolean isShowHours() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showHours), (Object)true);
    }

    public void setShowHours(boolean showHours) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showHours), (Object)showHours);
    }

    public boolean isShowMinutes() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMinutes), (Object)true);
    }

    public void setShowMinutes(boolean showMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMinutes), (Object)showMinutes);
    }

    public boolean isShowCloseButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showCloseButton), (Object)false);
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showCloseButton), (Object)showCloseButton);
    }

    public boolean isShowDeselectButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showDeselectButton), (Object)false);
    }

    public void setShowDeselectButton(boolean showDeselectButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showDeselectButton), (Object)showDeselectButton);
    }

    public boolean isShowNowButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNowButton), (Object)false);
    }

    public void setShowNowButton(boolean showNowButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showNowButton), (Object)showNowButton);
    }

    public String getOnHourShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onHourShow), null);
    }

    public void setOnHourShow(String onHourShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onHourShow), (Object)onHourShow);
    }

    public String getOnMinuteShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onMinuteShow), null);
    }

    public void setOnMinuteShow(String onMinuteShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onMinuteShow), (Object)onMinuteShow);
    }

    public String getShowOn() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOn), (Object)"focus");
    }

    public void setShowOn(String showOn) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOn), (Object)showOn);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public Integer getMinHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHour), null);
    }

    public void setMinHour(Integer minHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minHour), (Object)minHour);
    }

    public Integer getMinMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minMinute), null);
    }

    public void setMinMinute(Integer minMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minMinute), (Object)minMinute);
    }

    public Integer getMaxHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxHour), null);
    }

    public void setMaxHour(Integer maxHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxHour), (Object)maxHour);
    }

    public Integer getMaxMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxMinute), null);
    }

    public void setMaxMinute(Integer maxMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxMinute), (Object)maxMinute);
    }

    public boolean isReadonlyInput() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyInput), (Object)false);
    }

    public void setReadonlyInput(boolean _readonlyInput) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyInput), (Object)_readonlyInput);
    }

    public int getSize() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.size), (Object)5);
    }

    public void setSize(int size) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.size), (Object)size);
    }

    public Locale calculateLocale() {
        if (this.appropriateLocale == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            this.appropriateLocale = LocaleUtils.resolveLocale((FacesContext)fc, (Object)this.getLocale(), (String)this.getClientId(fc));
        }
        return this.appropriateLocale;
    }

    public boolean isInline() {
        return this.getMode().equalsIgnoreCase("inline");
    }

    public boolean isSpinner() {
        return this.getMode().equalsIgnoreCase("spinner");
    }

    public boolean isShowOnButton() {
        return !"focus".equals(this.getShowOn());
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String eventName = (String)fc.getExternalContext().getRequestParameterMap().get("jakarta.faces.behavior.event");
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            if ("timeSelect".equals(eventName)) {
                this.customEvents.put("timeSelect", (AjaxBehaviorEvent)event);
                return;
            }
            if ("beforeShow".equals(eventName)) {
                BeforeShowEvent beforeShowEvent = new BeforeShowEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                beforeShowEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)beforeShowEvent);
                return;
            }
            if ("close".equals(eventName)) {
                CloseEvent closeEvent = new CloseEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                closeEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                return;
            }
        }
        super.queueEvent(event);
    }

    public void validate(FacesContext fc) {
        super.validate(fc);
        if (this.isValid()) {
            for (Map.Entry<String, AjaxBehaviorEvent> entry : this.customEvents.entrySet()) {
                AjaxBehaviorEvent behaviorEvent = entry.getValue();
                TimeSelectEvent<Object> timeSelectEvent = new TimeSelectEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), this.getValue());
                if (behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    timeSelectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    timeSelectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent(timeSelectEvent);
            }
        }
    }

    public String getTimePattern24() {
        return "HH" + this.getTimeSeparator() + "mm";
    }

    public String getTimePattern12() {
        return "hh" + this.getTimeSeparator() + "mm a";
    }

    private boolean isSelfRequest(FacesContext fc) {
        return this.getClientId(fc).equals(fc.getExternalContext().getRequestParameterMap().get("jakarta.faces.source"));
    }

    public Object saveState(FacesContext context) {
        this.appropriateLocale = null;
        this.customEvents.clear();
        return super.saveState(context);
    }

    protected static enum PropertyKeys {
        widgetVar,
        timeSeparator,
        showPeriod,
        dialogPosition,
        inputPosition,
        mode,
        startHours,
        endHours,
        startMinutes,
        endMinutes,
        intervalMinutes,
        rows,
        showHours,
        showMinutes,
        showCloseButton,
        showNowButton,
        showDeselectButton,
        onHourShow,
        onMinuteShow,
        showOn,
        locale,
        minHour,
        minMinute,
        maxHour,
        maxMinute,
        readonlyInput,
        size;

    }
}

