/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.legend;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.extensions.component.legend.Legend;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class LegendRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Legend legend = (Legend)component;
        this.encodeMarkup(context, legend);
        this.encodeScript(context, legend);
    }

    private void encodeMarkup(FacesContext context, Legend legend) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = legend.getClientId(context);
        String widgetVar = legend.resolveWidgetVar();
        String styleClass = this.getStyleClassBuilder(context).add(legend.getLayout().equalsIgnoreCase("vertical") ? "ui-legend-vertical " : "ui-legend-horizontal ").add(legend.getStyleClass()).build();
        writer.startElement("div", (UIComponent)legend);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (legend.getStyle() != null) {
            writer.writeAttribute("style", (Object)legend.getStyle(), "style");
        }
        this.encodeTitle(context, legend);
        this.encodeItems(context, legend);
        this.encodeFooter(context, legend);
        writer.endElement("div");
    }

    private void encodeItems(FacesContext context, Legend legend) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-legend-scale", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-legend-labels", null);
        Map<String, String> values = legend.getValues();
        for (Map.Entry<String, String> item : values.entrySet()) {
            writer.startElement("li", null);
            writer.startElement("span", null);
            writer.writeAttribute("style", (Object)("background:" + item.getValue()), null);
            writer.endElement("span");
            writer.writeText((Object)item.getKey(), null);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    private void encodeTitle(FacesContext context, Legend legend) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = legend.getFacet("title");
        String title = legend.getTitle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-legend-title", null);
        if (FacetUtils.shouldRenderFacet((UIComponent)facet)) {
            facet.encodeAll(context);
        } else if (title != null) {
            writer.writeText((Object)title, null);
        } else {
            writer.write("&nbsp;");
        }
        writer.endElement("div");
    }

    private void encodeFooter(FacesContext context, Legend legend) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = legend.getFacet("footer");
        String footer = legend.getFooter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-legend-footer", null);
        if (FacetUtils.shouldRenderFacet((UIComponent)facet)) {
            facet.encodeAll(context);
        } else if (footer != null) {
            writer.writeText((Object)footer, null);
        } else {
            writer.write("&nbsp;");
        }
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Legend legend) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtLegend", (UIComponent)legend);
        wb.attr("layout", legend.getLayout());
        wb.finish();
    }
}

