/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.util.ResourceExtUtils;
import org.primefaces.util.MapBuilder;

public class PrimeFacesResourceProcessor
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final String LIBRARY = "primefaces";
    private static final Map<String, String> THEME_MAPPING = MapBuilder.builder().put((Object)"saga", (Object)"saga-blue").put((Object)"arya", (Object)"arya-blue").put((Object)"vela", (Object)"vela-blue").build();

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        String theme;
        FacesContext context = event.getFacesContext();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        String themeParamValue = applicationContext.getConfig().getTheme();
        if (themeParamValue != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "saga-blue";
        }
        if (theme != null && !"none".equals(theme)) {
            if (THEME_MAPPING.containsKey(theme)) {
                theme = THEME_MAPPING.get(theme);
            }
            ResourceExtUtils.addCssResource(context, "primefaces-" + theme, "theme.css");
        }
        if (configuration.isPrimeIconsEnabled()) {
            ResourceExtUtils.addCssResource(context, LIBRARY, "primeicons/primeicons.css");
        }
    }

    public void afterPhase(PhaseEvent event) {
    }
}

