/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputphone;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.extensions.component.inputphone.InputPhone;
import org.primefaces.extensions.config.PrimeExtensionsEnvironment;
import org.primefaces.extensions.util.PhoneNumberUtilWrapper;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.shaded.json.JSONArray;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class InputPhoneRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(InputPhoneRenderer.class.getName());
    private static final String HIDDEN_ID = "_hidden";
    private static final String ISO2_ID = "_iso2";

    public void decode(FacesContext context, UIComponent component) {
        InputPhone inputPhone = (InputPhone)component;
        if (!this.shouldDecode((UIInput)inputPhone)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputPhone);
        String inputId = inputPhone.getClientId(context) + HIDDEN_ID;
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputPhone.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputPhone inputPhone = (InputPhone)component;
        Object value = inputPhone.getValue();
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputPhone, (Object)value);
        if (valueToRender == null) {
            valueToRender = "";
        }
        this.encodeMarkup(context, inputPhone, valueToRender);
        this.encodeScript(context, inputPhone);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        String value = (String)submittedValue;
        if (LangUtils.isBlank((String)value)) {
            return null;
        }
        InputPhone inputPhone = (InputPhone)component;
        Converter converter = inputPhone.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)inputPhone, value);
        }
        String country = (String)context.getExternalContext().getRequestParameterMap().get(inputPhone.getClientId() + ISO2_ID);
        if (country == null || "auto".equals(country)) {
            country = "";
        } else {
            inputPhone.setInitialCountry(country);
        }
        if (this.needsValidation(context) && PrimeExtensionsEnvironment.getCurrentInstance(context).isLibphonenumberAvailable()) {
            PhoneNumberUtilWrapper.validate(value, country.toUpperCase(), inputPhone.getValidatorMessage());
        } else {
            LOGGER.warning("Libphonenumber not available, unable to validate!");
        }
        return value;
    }

    protected boolean needsValidation(FacesContext context) {
        String eventName = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.behavior.event");
        return !"countrySelect".equals(eventName);
    }

    protected void encodeMarkup(FacesContext context, InputPhone inputPhone, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputPhone.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add("ui-inputphone ui-widget").add(inputPhone.getStyleClass()).build();
        writer.startElement("span", (UIComponent)inputPhone);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputPhone.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputPhone.getStyle(), "style");
        }
        this.renderRTLDirection(context, (UIComponent)inputPhone);
        this.encodeInput(context, inputPhone, clientId, valueToRender);
        this.encodeHiddenInputs(context, inputPhone, clientId, valueToRender);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, InputPhone inputPhone, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String inputStyle = inputPhone.getInputStyle();
        String styleClass = this.createStyleClass((UIInput)inputPhone, "inputStyleClass", "ui-inputfield ui-inputtext ui-widget ui-state-default");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputPhone.getType(), null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        writer.writeAttribute("class", (Object)styleClass, "inputStyleClass");
        if (!this.isValueBlank(inputStyle)) {
            writer.writeAttribute("style", (Object)inputStyle, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)inputPhone);
        this.renderPassThruAttributes(context, (UIComponent)inputPhone, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputPhone, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputPhone, new ClientValidator[0]);
        writer.endElement("input");
    }

    protected void encodeHiddenInputs(FacesContext context, InputPhone inputPhone, String clientId, String valueToRender) throws IOException {
        this.renderHiddenInput(context, clientId + ISO2_ID, inputPhone.getInitialCountry(), inputPhone.isDisabled());
        this.renderHiddenInput(context, clientId + HIDDEN_ID, valueToRender, inputPhone.isDisabled());
    }

    protected void encodeScript(FacesContext context, InputPhone inputPhone) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtInputPhone", (UIComponent)inputPhone);
        this.encodeCountries(wb, "excludeCountries", inputPhone.getExcludeCountries());
        wb.attr("allowDropdown", inputPhone.isAllowDropdown(), true);
        wb.attr("autoHideDialCode", inputPhone.isAutoHideDialCode(), true);
        wb.attr("fixDropdownWidth", inputPhone.isFixDropdownWidth(), true);
        wb.attr("formatOnDisplay", inputPhone.isFormatOnDisplay(), true);
        wb.attr("formatAsYouType", inputPhone.isFormatAsYouType(), true);
        wb.attr("nationalMode", inputPhone.isNationalMode(), true);
        wb.attr("separateDialCode", inputPhone.isSeparateDialCode(), false);
        if (inputPhone.getAutoPlaceholderEnum() != InputPhone.AutoPlaceholder.polite) {
            wb.attr("autoPlaceholder", inputPhone.getAutoPlaceholder());
        }
        if (LangUtils.isNotBlank((String)inputPhone.getInitialCountry())) {
            wb.attr("initialCountry", inputPhone.getInitialCountry());
        }
        if ("auto".equals(inputPhone.getInitialCountry())) {
            if (inputPhone.getGeoIpLookup() == null) {
                throw new FacesException("InputPhone geoIpLookup property is required when initialCountry is 'auto'.");
            }
            wb.nativeAttr("geoIpLookup", inputPhone.getGeoIpLookup());
        }
        this.encodeCountries(wb, "onlyCountries", inputPhone.getOnlyCountries());
        if (inputPhone.getPlaceholderNumberTypeEnum() != InputPhone.PlaceholderNumberType.mobile) {
            wb.attr("placeholderNumberType", inputPhone.getPlaceholderNumberType().toUpperCase());
        }
        this.encodeCountries(wb, "countryOrder", inputPhone.getPreferredCountries());
        if (inputPhone.getLocalizedCountries() != null) {
            wb.nativeAttr("i18n", this.objectToJsonString(inputPhone.getLocalizedCountries()));
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputPhone);
        wb.finish();
    }

    private void encodeCountries(WidgetBuilder wb, String attribute, Object value) throws IOException {
        Collection<String> countries = this.toCollection(value);
        if (!countries.isEmpty()) {
            wb.nativeAttr(attribute, new JSONArray(countries).toString());
        }
    }

    private Collection<String> toCollection(Object object) {
        if (object instanceof String) {
            String string = ((String)object).replace(' ', ',').toLowerCase();
            return Arrays.asList(string.split(","));
        }
        return (Collection)object;
    }

    private String objectToJsonString(Object object) {
        if (object == null || object instanceof String) {
            return (String)object;
        }
        Map map = (Map)object;
        JSONObject jsonObj = new JSONObject();
        map.forEach((arg_0, arg_1) -> ((JSONObject)jsonObj).put(arg_0, arg_1));
        return jsonObj.toString();
    }
}

