/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.tristatemanycheckbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.extensions.component.tristatemanycheckbox.TriStateManyCheckbox;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.WidgetBuilder;

public class TriStateManyCheckboxRenderer
extends SelectManyRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        if (submittedValue instanceof Map) {
            Map mapSub = (Map)submittedValue;
            ArrayList keyValues = new ArrayList(mapSub.keySet());
            LinkedHashMap<String, Object> mapSubConv = new LinkedHashMap<String, Object>();
            TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
            Converter converter = checkbox.getConverter();
            if (converter != null) {
                for (String keyVal : keyValues) {
                    Object mapVal = converter.getAsObject(context, (UIComponent)checkbox, (String)mapSub.get(keyVal));
                    mapSubConv.put(keyVal, mapVal);
                }
                return mapSubConv;
            }
            return mapSub;
        }
        throw new FacesException("Value of '" + component.getClientId() + "'must be a Map instance");
    }

    public void decode(FacesContext context, UIComponent component) {
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        if (!this.shouldDecode((UIInput)checkbox)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)checkbox);
        String submitParam = this.getSubmitParam(context, (UISelectMany)checkbox);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] valuesArray = null;
        if (params.containsKey(submitParam)) {
            valuesArray = (String[])params.get(submitParam);
        }
        checkbox.setSubmittedValue(this.getSubmitedMap(context, checkbox, valuesArray));
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, TriStateManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        String style = checkbox.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-selectmanycheckbox ui-widget").add(checkbox.getStyleClass()).build();
        writer.startElement("table", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, checkbox);
        writer.endElement("table");
    }

    protected void encodeSelectItems(FacesContext context, TriStateManyCheckbox checkbox) throws IOException {
        boolean pageDirection;
        ResponseWriter writer = context.getResponseWriter();
        List selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Map<String, Object> values = this.getValues((UIComponent)checkbox);
        Map<String, Object> submittedMap = this.getSubmittedFromComp((UIComponent)checkbox);
        String layout = checkbox.getLayout();
        boolean bl = pageDirection = layout != null && "pageDirection".equals(layout);
        if (submittedMap != null) {
            values = submittedMap;
        }
        if (converter != null && submittedMap == null) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String keyValue = converter.getAsString(context, (UIComponent)checkbox, entry.getValue());
                values.put(entry.getKey(), keyValue);
            }
        }
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            ++idx;
            if (pageDirection) {
                writer.startElement("tr", null);
            }
            this.encodeOption(context, (UIInput)checkbox, values, selectItem, idx);
            if (!pageDirection) continue;
            writer.endElement("tr");
        }
    }

    protected void encodeOption(FacesContext context, UIInput component, Map<String, Object> values, SelectItem option, int idx) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        String itemValueAsString = String.valueOf(option.getValue());
        String name = checkbox.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean disabled = option.isDisabled() || checkbox.isDisabled();
        String itemValue = (String)option.getValue();
        int valueInput = this.getValueForInput(component, itemValue, values);
        if (option.isNoSelectionOption() && values != null && "".equals(itemValue)) {
            return;
        }
        writer.startElement("td", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        this.encodeOptionInput(context, checkbox, id, name, disabled, itemValueAsString, valueInput);
        this.encodeOptionOutput(context, checkbox, valueInput, disabled);
        writer.endElement("div");
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeOptionLabel(context, id, option, disabled);
        writer.endElement("td");
    }

    protected void encodeOptionInput(FacesContext context, TriStateManyCheckbox checkbox, String id, String name, boolean disabled, String value, int valueInput) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("value", (Object)valueInput, null);
        writer.writeAttribute("itemValue", (Object)value, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checkbox.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)checkbox.getOnchange(), null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionOutput(FacesContext context, TriStateManyCheckbox checkbox, int valCheck, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-chkbox-box ui-widget ui-state-default").add(valCheck == 1 || valCheck == 2, "ui-state-active").add(disabled, "ui-state-disabled").build();
        String stateOneIconClass = checkbox.getStateOneIcon() != null ? "ui-icon " + checkbox.getStateOneIcon() : "";
        String stateTwoIconClass = checkbox.getStateTwoIcon() != null ? "ui-icon " + checkbox.getStateTwoIcon() : "ui-icon ui-icon-check";
        String stataThreeIconClass = checkbox.getStateThreeIcon() != null ? "ui-icon " + checkbox.getStateThreeIcon() : "ui-icon ui-icon-closethick";
        String comma = "\",\"";
        String statesIconsClasses = "[\"" + stateOneIconClass + "\",\"" + stateTwoIconClass + "\",\"" + stataThreeIconClass + "\"]";
        String statesTitles = "[\"" + EscapeUtils.forJavaScript((String)checkbox.getStateOneTitle()) + "\",\"" + EscapeUtils.forJavaScript((String)checkbox.getStateTwoTitle()) + "\",\"" + EscapeUtils.forJavaScript((String)checkbox.getStateThreeTitle()) + "\"]";
        Object iconClass = "ui-chkbox-icon ui-icon ui-c";
        String activeTitle = "";
        if (valCheck == 0) {
            iconClass = (String)iconClass + " " + stateOneIconClass;
            activeTitle = checkbox.getStateOneTitle();
        } else if (valCheck == 1) {
            iconClass = (String)iconClass + " " + stateTwoIconClass;
            activeTitle = checkbox.getStateTwoTitle();
        } else if (valCheck == 2) {
            iconClass = (String)iconClass + " " + stataThreeIconClass;
            activeTitle = checkbox.getStateThreeTitle();
        }
        Object dataTitles = "";
        Object titleAtt = "";
        if (!(checkbox.getStateOneTitle().isEmpty() && checkbox.getStateTwoTitle().isEmpty() && checkbox.getStateThreeTitle().isEmpty())) {
            dataTitles = "data-titlestates='" + statesTitles + "' ";
            titleAtt = " title=\"" + EscapeUtils.forJavaScript((String)activeTitle) + "\" ";
        }
        Object tabIndexTag = " tabIndex=0 ";
        if (checkbox.getTabindex() != null) {
            tabIndexTag = "tabIndex=" + checkbox.getTabindex() + " ";
        }
        writer.write("<div " + (String)tabIndexTag + (String)titleAtt + "class=\"" + styleClass + "\" data-iconstates='" + statesIconsClasses + "' " + (String)dataTitles + "><span class=\"" + (String)iconClass + "\"></span></div>");
    }

    protected void encodeScript(FacesContext context, TriStateManyCheckbox checkbox) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtTriStateManyCheckbox", (UIComponent)checkbox);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)checkbox);
        wb.finish();
    }

    protected void encodeOptionLabel(FacesContext context, String containerClientId, SelectItem option, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)containerClientId, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }

    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    protected int getValueForInput(UIInput component, String itemValue, Map<String, Object> valueArray) {
        try {
            int retInt = 0;
            if (itemValue == null || valueArray == null) {
                return retInt;
            }
            if (valueArray.containsKey(itemValue)) {
                retInt = Integer.parseInt((String)valueArray.get(itemValue));
                return retInt % 3;
            }
            return retInt;
        }
        catch (NumberFormatException ex) {
            throw new FacesException("State of '" + component.getClientId() + "' must be an integer representation");
        }
    }

    protected Map getValues(UIComponent component) {
        UISelectMany selectMany = (UISelectMany)component;
        Object value = selectMany.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new FacesException("Value of '" + component.getClientId() + "'must be a Map instance");
    }

    protected Map<String, Object> getSubmitedMap(FacesContext context, TriStateManyCheckbox checkbox, String[] valuesArray) {
        List selectItems = this.getSelectItems(context, (UIInput)checkbox);
        LinkedHashMap<String, Object> subValues = new LinkedHashMap<String, Object>();
        if (valuesArray != null && valuesArray.length == selectItems.size()) {
            int idx = -1;
            for (SelectItem item : selectItems) {
                String keyMap = (String)item.getValue();
                String valueMap = valuesArray[++idx];
                subValues.put(keyMap, valueMap);
            }
            return subValues;
        }
        return null;
    }

    protected Map<String, Object> getSubmittedFromComp(UIComponent component) {
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        Map ret = (Map)checkbox.getSubmittedValue();
        if (ret != null) {
            LinkedHashMap<String, Object> subValues = new LinkedHashMap<String, Object>();
            Set keys = ret.keySet();
            String[] tempArray = keys.toArray(new String[0]);
            int length = tempArray.length;
            for (int i = length - 1; i >= 0; --i) {
                String key = tempArray[i];
                Object val = ret.get(key);
                subValues.put(key, val);
            }
            return subValues;
        }
        return null;
    }
}

