/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.importenum;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.extensions.component.importenum.EnumHashMap;
import org.primefaces.extensions.util.ClassUtils;

public class ImportEnumTagHandler
extends TagHandler {
    private static final String DEFAULT_ALL_SUFFIX = "ALL_VALUES";
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<Class<?>, Map<String, Object>>> CACHE = new ConcurrentHashMap();
    private final TagAttribute typeTagAttribute = super.getRequiredAttribute("type");
    private final TagAttribute varTagAttribute = super.getAttribute("var");
    private final TagAttribute allSuffixTagAttribute = super.getAttribute("allSuffix");

    public ImportEnumTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        Class<?> clazz = this.getClassFromAttribute(this.typeTagAttribute, ctx);
        Map<String, Object> enumValues = this.getEnumValues(clazz, this.allSuffixTagAttribute == null ? DEFAULT_ALL_SUFFIX : this.allSuffixTagAttribute.getValue(ctx));
        String var = this.varTagAttribute == null ? clazz.getSimpleName() : this.varTagAttribute.getValue(ctx);
        if (var.charAt(0) != '#') {
            StringBuilder varBuilder = new StringBuilder();
            varBuilder.append("#{").append(var).append("}");
            var = varBuilder.toString();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        ValueExpression aliasValueExpression = expressionFactory.createValueExpression(elContext, var, Map.class);
        aliasValueExpression.setValue(elContext, enumValues);
    }

    protected Class<?> getClassFromAttribute(TagAttribute attribute, FaceletContext ctx) {
        String className = attribute.getValue(ctx);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException("Class " + className + " not found.", (Throwable)e);
        }
    }

    protected Map<String, Object> getEnumValues(Class<?> clazz, String allPrefix) {
        if (clazz.isEnum()) {
            EnumHashMap<String, Object> enums;
            ConcurrentMap cache;
            ClassLoader classLoader = ClassUtils.getClassLoader(clazz);
            if (!CACHE.containsKey(classLoader)) {
                CACHE.put(classLoader, new ConcurrentHashMap());
            }
            if ((cache = (ConcurrentMap)CACHE.get(classLoader)).containsKey(clazz)) {
                enums = (EnumHashMap<String, Object>)cache.get(clazz);
            } else {
                enums = new EnumHashMap<String, Object>(clazz);
                for (Object value : clazz.getEnumConstants()) {
                    Enum currentEnum = (Enum)value;
                    enums.put(currentEnum.name(), currentEnum);
                }
                enums.put(allPrefix, clazz.getEnumConstants());
                cache.put(clazz, enums);
            }
            return enums;
        }
        throw new FacesException("Class '" + clazz + "' is not an enum.");
    }
}

