/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.knob;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="knob/knob.js")})
public class Knob
extends UIInput
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Knob";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("change"));
    private static final String DEFAULT_THEME = "aristo";

    public Knob() {
        this.setRendererType("org.primefaces.extensions.component.KnobRenderer");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "change";
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public int getMin() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.min), (Object)0);
    }

    public void setMin(int min) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.min), (Object)min);
    }

    public int getMax() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.max), (Object)100);
    }

    public void setMax(int max) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.max), (Object)max);
    }

    public int getStep() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.step), (Object)1);
    }

    public void setStep(int step) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.step), (Object)step);
    }

    public Object getHeight() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height));
    }

    public void setHeight(Object height) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), height);
    }

    public Object getWidth() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width));
    }

    public void setWidth(Object width) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), width);
    }

    public String getOnchange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onchange));
    }

    public void setOnchange(String onchange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onchange), (Object)onchange);
    }

    public boolean isShowLabel() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showLabel), (Object)true);
    }

    public void setShowLabel(boolean showLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showLabel), (Object)showLabel);
    }

    public String getLabelTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.labelTemplate), (Object)"{value}");
    }

    public void setLabelTemplate(String labelTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.labelTemplate), (Object)labelTemplate);
    }

    public boolean isDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabled), (Object)false);
    }

    public void setDisabled(boolean disabled) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabled), (Object)disabled);
    }

    public boolean isCursor() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cursor), (Object)false);
    }

    public void setCursor(boolean cursor) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cursor), (Object)cursor);
    }

    public Float getThickness() {
        return (Float)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.thickness));
    }

    public void setThickness(Float thickness) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.thickness), (Object)thickness);
    }

    public Object getForegroundColor() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.foregroundColor));
    }

    public void setForegroundColor(Object foregroundColor) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.foregroundColor), foregroundColor);
    }

    public String getColorTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colorTheme), (Object)this.getDefaultColorTheme());
    }

    private String getDefaultColorTheme() {
        String defaultTheme = DEFAULT_THEME;
        if (StringUtils.isNotEmpty((CharSequence)RequestContext.getCurrentInstance().getApplicationContext().getConfig().getTheme())) {
            ELContext elContext = this.getFacesContext().getELContext();
            ValueExpression defaultThemeVE = this.getFacesContext().getApplication().getExpressionFactory().createValueExpression(elContext, RequestContext.getCurrentInstance().getApplicationContext().getConfig().getTheme(), String.class);
            defaultTheme = (String)defaultThemeVE.getValue(elContext);
        }
        return defaultTheme;
    }

    public void setColorTheme(String colorScheme) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colorTheme), (Object)colorScheme);
    }

    public Object getBackgroundColor() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.backgroundColor));
    }

    public void setBackgroundColor(Object backgroundColor) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.backgroundColor), backgroundColor);
    }

    protected static enum PropertyKeys {
        foregroundColor,
        backgroundColor,
        showLabel,
        labelTemplate,
        onchange,
        height,
        width,
        step,
        min,
        max,
        widgetVar,
        disabled,
        cursor,
        thickness,
        colorTheme;

    }
}

