/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.knob;

import java.awt.Color;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.component.knob.Knob;
import org.primefaces.extensions.util.ColorUtils;
import org.primefaces.extensions.util.ExtWidgetBuilder;
import org.primefaces.renderkit.CoreRenderer;

public class KnobRenderer
extends CoreRenderer {
    public static final String RENDERER_TYPE = "org.primefaces.extensions.component.KnobRenderer";

    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(component.getClientId(context) + "_hidden");
        ((Knob)component).setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeMarkup(context, (Knob)component);
        this.encodeScript(context, (Knob)component);
    }

    private void encodeMarkup(FacesContext context, Knob knob) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = knob.getValue() != null ? knob.getValue() : Integer.valueOf(0);
        writer.startElement("input", (UIComponent)knob);
        writer.writeAttribute("id", (Object)knob.getClientId(), null);
        writer.writeAttribute("name", (Object)knob.getClientId(), null);
        writer.writeAttribute("disabled", (Object)true, null);
        writer.writeAttribute("value", (Object)value.toString(), null);
        writer.writeAttribute("data-min", (Object)knob.getMin(), null);
        writer.writeAttribute("data-step", (Object)knob.getStep(), null);
        writer.writeAttribute("data-max", (Object)knob.getMax(), null);
        writer.writeAttribute("data-displayInput", (Object)Boolean.toString(knob.isShowLabel()), null);
        writer.writeAttribute("data-readOnly", (Object)Boolean.toString(knob.isDisabled()), null);
        writer.writeAttribute("data-cursor", (Object)Boolean.toString(knob.isCursor()), null);
        if (knob.getThickness() != null) {
            writer.writeAttribute("data-thickness", (Object)knob.getThickness(), null);
        }
        if (knob.getWidth() != null) {
            writer.writeAttribute("data-width", (Object)knob.getWidth().toString(), null);
        }
        if (knob.getHeight() != null) {
            writer.writeAttribute("data-height", (Object)knob.getHeight().toString(), null);
        }
        writer.writeAttribute("class", (Object)"knob", null);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(knob.getClientId() + "_hidden"), null);
        writer.writeAttribute("name", (Object)(knob.getClientId() + "_hidden"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)value.toString(), null);
        writer.endElement("input");
    }

    private void encodeScript(FacesContext context, Knob knob) throws IOException {
        String clientId = knob.getClientId();
        String widgetVar = knob.resolveWidgetVar();
        ExtWidgetBuilder ewb = ExtWidgetBuilder.get(context);
        ewb.initWithDomReady("Knob", widgetVar, clientId);
        ewb.attr("labelTemplate", knob.getLabelTemplate());
        ewb.attr("colorTheme", knob.getColorTheme());
        ewb.callback("onchange", "function(value)", knob.getOnchange());
        if (knob.getForegroundColor() != null) {
            String fg = knob.getForegroundColor() instanceof Color ? ColorUtils.colorToHex((Color)knob.getForegroundColor()) : knob.getForegroundColor().toString();
            ewb.attr("fgColor", fg);
        }
        if (knob.getBackgroundColor() != null) {
            String bg = knob.getBackgroundColor() instanceof Color ? ColorUtils.colorToHex((Color)knob.getBackgroundColor()) : knob.getBackgroundColor().toString();
            ewb.attr("bgColor", bg);
        }
        this.encodeClientBehaviors(context, knob);
        ewb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            submittedValue = 0;
        }
        try {
            return submittedValue instanceof Integer ? submittedValue : Integer.valueOf(Integer.parseInt(submittedValue.toString()));
        }
        catch (NumberFormatException e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

