/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.qrcode;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.qrcode.QRCode;
import org.primefaces.extensions.util.ExtWidgetBuilder;
import org.primefaces.renderkit.CoreRenderer;

public class QRCodeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        QRCode qrCode = (QRCode)component;
        this.encodeMarkup(context, qrCode);
        this.encodeScript(context, qrCode);
    }

    protected void encodeScript(FacesContext context, QRCode qrCode) throws IOException {
        ExtWidgetBuilder wb = ExtWidgetBuilder.get(context);
        wb.initWithDomReady(QRCode.class.getSimpleName(), qrCode.resolveWidgetVar(), qrCode.getClientId());
        wb.attr("render", qrCode.getRenderMethod()).attr("mode", (Number)qrCode.getRenderMode()).attr("minVersion", (Number)qrCode.getMinVersion()).attr("maxVersion", (Number)qrCode.getMaxVersion()).attr("left", (Number)qrCode.getLeftOffset()).attr("top", (Number)qrCode.getTopOffset()).attr("size", (Number)qrCode.getSize()).attr("fill", qrCode.getFillColor()).attr("ecLevel", qrCode.getEcLevel()).attr("background", qrCode.getBackground()).attr("text", qrCode.getText()).attr("radius", (Number)qrCode.getRadius()).attr("quiet", (Number)qrCode.getQuiet()).attr("mSize", (Number)qrCode.getMSize()).attr("mPosX", (Number)qrCode.getMPosX()).attr("mPosY", (Number)qrCode.getMPosY()).attr("label", qrCode.getLabel()).attr("fontname", qrCode.getFontName()).attr("fontcolor", qrCode.getFontColor());
        wb.finish();
    }

    private void encodeMarkup(FacesContext context, QRCode qrCode) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = qrCode.getClientId(context);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

