/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.dynaform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.extensions.model.dynaform.AbstractDynaFormElement;
import org.primefaces.extensions.model.dynaform.DynaFormControl;
import org.primefaces.extensions.model.dynaform.DynaFormLabel;
import org.primefaces.extensions.model.dynaform.DynaFormModel;

public class DynaFormRow
implements Serializable {
    private static final long serialVersionUID = 20120514L;
    private int row;
    private boolean extended;
    private int totalColspan = 0;
    private DynaFormModel dynaFormModel;
    private List<AbstractDynaFormElement> elements = new ArrayList<AbstractDynaFormElement>();

    public DynaFormRow() {
    }

    public DynaFormRow(int row, boolean extended, DynaFormModel dynaFormModel) {
        this.row = row;
        this.extended = extended;
        this.dynaFormModel = dynaFormModel;
    }

    public DynaFormControl addControl(Object data) {
        return this.addControl(data, "default", 1, 1);
    }

    public DynaFormControl addControl(Object data, String type) {
        return this.addControl(data, type, 1, 1);
    }

    public DynaFormControl addControl(Object data, int colspan, int rowspan) {
        return this.addControl(data, "default", colspan, rowspan);
    }

    public DynaFormControl addControl(Object data, String type, int colspan, int rowspan) {
        DynaFormControl dynaFormControl = new DynaFormControl(data, type, colspan, rowspan, this.row, this.elements.size() + 1, this.extended);
        this.elements.add(dynaFormControl);
        this.dynaFormModel.getControls().add(dynaFormControl);
        this.totalColspan += colspan;
        return dynaFormControl;
    }

    public DynaFormLabel addLabel(String value) {
        return this.addLabel(value, true, 1, 1);
    }

    public DynaFormLabel addLabel(String value, int colspan, int rowspan) {
        return this.addLabel(value, true, colspan, rowspan);
    }

    public DynaFormLabel addLabel(String value, boolean escape, int colspan, int rowspan) {
        DynaFormLabel dynaFormLabel = new DynaFormLabel(value, escape, colspan, rowspan, this.row, this.elements.size() + 1, this.extended);
        this.elements.add(dynaFormLabel);
        this.dynaFormModel.getLabels().add(dynaFormLabel);
        this.totalColspan += colspan;
        return dynaFormLabel;
    }

    public List<AbstractDynaFormElement> getElements() {
        return this.elements;
    }

    public int getTotalColspan() {
        return this.totalColspan;
    }

    void setRow(int row) {
        this.row = row;
    }
}

