/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.gchart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.context.RequestContext;
import org.primefaces.extensions.component.gchart.GChart;
import org.primefaces.extensions.component.gchart.model.GChartModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class GChartRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        GChart gChart = (GChart)component;
        this.encodeMarkup(context, gChart);
        this.encodeScript(context, gChart);
    }

    protected void encodeMarkup(FacesContext context, GChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)chart);
        writer.writeAttribute("id", (Object)(chart.getClientId() + "_hidden"), null);
        writer.writeAttribute("name", (Object)(chart.getClientId() + "_hidden"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
        writer.startElement("div", (UIComponent)chart);
        writer.writeAttribute("id", (Object)chart.getClientId(), null);
        writer.endElement("div");
        this.startScript(writer, chart.getClientId());
        writer.writeAttribute("src", (Object)"https://www.google.com/jsapi", null);
        this.endScript(writer);
    }

    protected void encodeScript(FacesContext context, GChart chart) throws IOException {
        String clientId = chart.getClientId();
        String widgetVar = chart.resolveWidgetVar();
        WidgetBuilder wb = RequestContext.getCurrentInstance().getWidgetBuilder();
        wb.init("ExtGChart", widgetVar, clientId).attr("chart", this.escapeText(((GChartModel)chart.getValue()).toJson())).attr("title", chart.getTitle()).attr("width", (Number)chart.getWidth()).attr("height", (Number)chart.getHeight());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }
}

