/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.ActionEvent;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.Column;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.roweditor.RowEditor;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.util.ComponentUtils;

public abstract class Exporter {
    protected String skipComponents;

    public abstract void export(ActionEvent var1, String var2, FacesContext var3, String var4, String var5, boolean var6, boolean var7, String var8, MethodExpression var9, MethodExpression var10, boolean var11) throws IOException;

    public abstract void customFormat(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10) throws IOException;

    protected String exportValue(FacesContext context, UIComponent component) {
        Object value;
        HtmlOutputLink link;
        List children;
        if (component instanceof CellEditor) {
            return this.exportValue(context, component.getFacet("output"));
        }
        if (component instanceof RowEditor) {
            return "RowEditor";
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link2 = (HtmlCommandLink)component;
            Object value2 = link2.getValue();
            if (value2 != null) {
                return String.valueOf(value2);
            }
            for (UIComponent child : link2.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof HtmlOutputLink && (children = (link = (HtmlOutputLink)component).getChildren()) != null) {
            return this.exportValue(context, (UIComponent)children.get(0));
        }
        if (component instanceof HtmlCommandButton) {
            HtmlCommandButton button = (HtmlCommandButton)component;
            value = button.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : button.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof HtmlSelectOneMenu) {
            HtmlSelectOneMenu oneMenu = (HtmlSelectOneMenu)component;
            value = oneMenu.getSubmittedValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : oneMenu.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (this.skipComponents.contains(component.getClass().getName())) {
            return "";
        }
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(context, component, value);
            }
            Converter converterForType = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
            if (converterForType != null) {
                return converterForType.getAsString(context, component, value);
            }
            return value.toString();
        }
        String value3 = component.toString();
        return value3.trim();
    }

    protected String exportFacetValue(FacesContext context, UIComponent component) {
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(context, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        return value.trim();
    }

    protected List<UIColumn> getColumnsToExport(UIData table) {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof UIColumn)) continue;
            UIColumn column = (UIColumn)child;
            columns.add(column);
        }
        return columns;
    }

    protected String addColumnValues(DataList dataList, StringBuilder input) {
        Iterator iterator = dataList.getChildren().iterator();
        if (iterator.hasNext()) {
            String value;
            UIComponent component = (UIComponent)iterator.next();
            if (component instanceof Column) {
                UIColumn column = (UIColumn)component;
                for (UIComponent childComponent : column.getChildren()) {
                    String value2;
                    if (!component.isRendered() || (value2 = this.exportValue(FacesContext.getCurrentInstance(), childComponent)) == null) continue;
                    input.append(value2 + "\n \n");
                }
                return input.toString();
            }
            if (component.isRendered() && (value = this.exportValue(FacesContext.getCurrentInstance(), component)) != null) {
                input.append(value + "\n \n");
            }
            return input.toString();
        }
        return null;
    }

    protected int getColumnsCount(DataTable table) {
        int count = 0;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            ++count;
        }
        return count;
    }

    protected int getColumnsCount(SubTable table) {
        int count = 0;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasHeaderColumn(DataTable table) {
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !(col instanceof UIColumn) && !(col instanceof DynamicColumn) || col.getFacet("header") == null && col.getHeaderText() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasHeaderColumn(SubTable table) {
        for (UIComponent child : table.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("header") == null && column.getHeaderText() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasFooterColumn(SubTable table) {
        for (UIComponent child : table.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("footer") == null && column.getHeaderText() == null) continue;
            return true;
        }
        return false;
    }

    public void setSkipComponents(String skipComponentsValue) {
        this.skipComponents = skipComponentsValue;
    }

    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

