/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timepicker;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.BeforeShowEvent;
import org.primefaces.extensions.event.CloseEvent;
import org.primefaces.extensions.event.TimeSelectEvent;
import org.primefaces.util.ArrayUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="timepicker/timepicker.css"), @ResourceDependency(library="primefaces-extensions", name="timepicker/timepicker.js")})
public class TimePicker
extends HtmlInputText
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.TimePicker";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.TimePickerRenderer";
    public static final String CONTAINER_CLASS = "pe-timepicker ui-widget ui-corner-all";
    public static final String INPUT_CLASS = "ui-inputfield pe-timepicker-input ui-state-default ui-corner-all";
    public static final String UP_BUTTON_CLASS = "pe-timepicker-button pe-timepicker-up ui-corner-tr ui-button ui-widget ui-state-default ui-button-text-only";
    public static final String DOWN_BUTTON_CLASS = "pe-timepicker-button pe-timepicker-down ui-corner-br ui-button ui-widget ui-state-default ui-button-text-only";
    public static final String UP_ICON_CLASS = "ui-icon ui-icon-triangle-1-n";
    public static final String DOWN_ICON_CLASS = "ui-icon ui-icon-triangle-1-s";
    public static final String BUTTON_TRIGGER_CLASS = "pe-timepicker-trigger ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
    public static final String BUTTON_TRIGGER_ICON_CLASS = "ui-button-icon-left ui-icon ui-icon-clock";
    public static final String BUTTON_TRIGGER_TEXT_CLASS = "ui-button-text";
    static final String[] INPUT_TEXT_ATTRS = ArrayUtils.concat((String[][])new String[][]{{"accesskey", "alt", "autocomplete", "dir", "lang", "maxlength", "size", "tabindex", "title"}, HTML.COMMON_EVENTS, HTML.CHANGE_SELECT_EVENTS, HTML.BLUR_FOCUS_EVENTS});
    public static final String TIME_MESSAGE_KEY = "javax.faces.converter.DateTimeConverter.TIME";
    private Locale appropriateLocale;
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("blur", "change", "valueChange", "click", "dblclick", "focus", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "beforeShow", "timeSelect", "close"));
    private final Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();

    public TimePicker() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public String getTimeSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeSeparator), (Object)":");
    }

    public void setTimeSeparator(String timeSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeSeparator), (Object)timeSeparator);
    }

    public boolean isShowPeriod() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showPeriod), (Object)false);
    }

    public void setShowPeriod(boolean showPeriod) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showPeriod), (Object)showPeriod);
    }

    public String getMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mode), (Object)"spinner");
    }

    public void setMode(String mode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mode), (Object)mode);
    }

    public String getDialogPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dialogPosition), (Object)"left top");
    }

    public void setDialogPosition(String dialogPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dialogPosition), (Object)dialogPosition);
    }

    public String getInputPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputPosition), (Object)"left bottom");
    }

    public void setInputPosition(String inputPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputPosition), (Object)inputPosition);
    }

    public int getStartHours() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.startHours), (Object)0);
    }

    public void setStartHours(int startHours) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.startHours), (Object)startHours);
    }

    public int getEndHours() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.endHours), (Object)23);
    }

    public void setEndHours(int endHours) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.endHours), (Object)endHours);
    }

    public int getStartMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.startMinutes), (Object)0);
    }

    public void setStartMinutes(int startMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.startMinutes), (Object)startMinutes);
    }

    public int getEndMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.endMinutes), (Object)55);
    }

    public void setEndMinutes(int endMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.endMinutes), (Object)endMinutes);
    }

    public int getIntervalMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.intervalMinutes), (Object)5);
    }

    public void setIntervalMinutes(int intervalMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.intervalMinutes), (Object)intervalMinutes);
    }

    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), (Object)4);
    }

    public void setRows(int rows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rows), (Object)rows);
    }

    public boolean isShowHours() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showHours), (Object)true);
    }

    public void setShowHours(boolean showHours) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showHours), (Object)showHours);
    }

    public boolean isShowMinutes() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMinutes), (Object)true);
    }

    public void setShowMinutes(boolean showMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMinutes), (Object)showMinutes);
    }

    public boolean isShowCloseButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showCloseButton), (Object)false);
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showCloseButton), (Object)showCloseButton);
    }

    public boolean isShowDeselectButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showDeselectButton), (Object)false);
    }

    public void setShowDeselectButton(boolean showDeselectButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showDeselectButton), (Object)showDeselectButton);
    }

    public boolean isShowNowButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNowButton), (Object)false);
    }

    public void setShowNowButton(boolean showNowButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showNowButton), (Object)showNowButton);
    }

    public String getOnHourShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onHourShow), null);
    }

    public void setOnHourShow(String onHourShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onHourShow), (Object)onHourShow);
    }

    public String getOnMinuteShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onMinuteShow), null);
    }

    public void setOnMinuteShow(String onMinuteShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onMinuteShow), (Object)onMinuteShow);
    }

    public String getShowOn() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOn), (Object)"focus");
    }

    public void setShowOn(String showOn) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOn), (Object)showOn);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public Integer getMinHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHour), null);
    }

    public void setMinHour(Integer minHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minHour), (Object)minHour);
    }

    public Integer getMinMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minMinute), null);
    }

    public void setMinMinute(Integer minMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minMinute), (Object)minMinute);
    }

    public Integer getMaxHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxHour), null);
    }

    public void setMaxHour(Integer maxHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxHour), (Object)maxHour);
    }

    public Integer getMaxMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxMinute), null);
    }

    public void setMaxMinute(Integer maxMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxMinute), (Object)maxMinute);
    }

    public boolean isReadonlyInput() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyInput), (Object)false);
    }

    public void setReadonlyInput(boolean _readonlyInput) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyInput), (Object)_readonlyInput);
    }

    public Locale calculateLocale() {
        if (this.appropriateLocale == null) {
            this.appropriateLocale = org.primefaces.extensions.util.ComponentUtils.resolveLocale(this.getLocale());
        }
        return this.appropriateLocale;
    }

    public boolean isInline() {
        return this.getMode().equalsIgnoreCase("inline");
    }

    public boolean isSpinner() {
        return this.getMode().equalsIgnoreCase("spinner");
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String eventName = (String)fc.getExternalContext().getRequestParameterMap().get("javax.faces.behavior.event");
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            if ("timeSelect".equals(eventName)) {
                this.customEvents.put("timeSelect", (AjaxBehaviorEvent)event);
                return;
            }
            if ("beforeShow".equals(eventName)) {
                BeforeShowEvent beforeShowEvent = new BeforeShowEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                beforeShowEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)beforeShowEvent);
                return;
            }
            if ("close".equals(eventName)) {
                CloseEvent closeEvent = new CloseEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                closeEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                return;
            }
        }
        super.queueEvent(event);
    }

    public void validate(FacesContext fc) {
        super.validate(fc);
        if (this.isValid()) {
            for (Map.Entry<String, AjaxBehaviorEvent> entry : this.customEvents.entrySet()) {
                AjaxBehaviorEvent behaviorEvent = entry.getValue();
                TimeSelectEvent timeSelectEvent = new TimeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), (Date)this.getValue());
                if (behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    timeSelectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    timeSelectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent((FacesEvent)timeSelectEvent);
            }
        }
    }

    public String getTimePattern24() {
        return "HH" + this.getTimeSeparator() + "mm";
    }

    public String getTimePattern12() {
        return "hh" + this.getTimeSeparator() + "mm a";
    }

    private boolean isSelfRequest(FacesContext fc) {
        return this.getClientId(fc).equals(fc.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    protected static enum PropertyKeys {
        widgetVar,
        timeSeparator,
        showPeriod,
        dialogPosition,
        inputPosition,
        mode,
        startHours,
        endHours,
        startMinutes,
        endMinutes,
        intervalMinutes,
        rows,
        showHours,
        showMinutes,
        showCloseButton,
        showNowButton,
        showDeselectButton,
        onHourShow,
        onMinuteShow,
        showOn,
        locale,
        minHour,
        minMinute,
        maxHour,
        maxMinute,
        readonlyInput;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

