/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.AjaxSource;

public class ComponentUtils {
    private ComponentUtils() {
    }

    public static Object getConvertedSubmittedValue(FacesContext fc, EditableValueHolder evh) {
        Object submittedValue = evh.getSubmittedValue();
        if (submittedValue == null) {
            return null;
        }
        try {
            Converter converter;
            UIComponent component = (UIComponent)evh;
            Renderer renderer = ComponentUtils.getRenderer(fc, component);
            if (renderer != null) {
                return renderer.getConvertedValue(fc, component, submittedValue);
            }
            if (submittedValue instanceof String && (converter = org.primefaces.util.ComponentUtils.getConverter((FacesContext)fc, (UIComponent)component)) != null) {
                return converter.getAsObject(fc, component, (String)submittedValue);
            }
        }
        catch (Exception e) {
            return null;
        }
        return submittedValue;
    }

    public static Renderer getRenderer(FacesContext fc, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType != null) {
            return fc.getRenderKit().getRenderer(component.getFamily(), rendererType);
        }
        return null;
    }

    public static boolean isAjaxifiedComponent(UIComponent component) {
        Collection behaviors;
        if (component instanceof AjaxSource && ((AjaxSource)component).isAjaxified()) {
            return true;
        }
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors().values()).isEmpty()) {
            for (List listBehaviors : behaviors) {
                for (ClientBehavior clientBehavior : listBehaviors) {
                    if (!(clientBehavior instanceof AjaxBehavior) && !(clientBehavior instanceof org.primefaces.behavior.ajax.AjaxBehavior)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String escapeSelector(String value) {
        StringBuilder builder = new StringBuilder();
        block4: for (char c : value.toCharArray()) {
            switch (c) {
                case '\\': {
                    builder.append("\\\\\\\\");
                    continue block4;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '>': 
                case '[': 
                case ']': 
                case '^': 
                case '|': 
                case '~': {
                    builder.append("\\\\");
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static Locale resolveLocale(Object locale) {
        if (locale instanceof String) {
            locale = org.primefaces.util.ComponentUtils.toLocale((String)((String)locale));
        }
        if (locale == null) {
            locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        }
        return (Locale)locale;
    }

    public static TimeZone resolveTimeZone(Object timeZone) {
        if (timeZone instanceof String) {
            return TimeZone.getTimeZone((String)timeZone);
        }
        if (timeZone instanceof TimeZone) {
            return (TimeZone)timeZone;
        }
        return TimeZone.getDefault();
    }
}

