/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.extensions.component.sheet.SheetColumn;
import org.primefaces.extensions.component.sheet.SheetInvalidUpdate;
import org.primefaces.extensions.event.SheetEvent;
import org.primefaces.extensions.model.sheet.SheetRowColIndex;
import org.primefaces.extensions.model.sheet.SheetUpdate;
import org.primefaces.extensions.util.JavascriptVarBuilder;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.SortOrder;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces-extensions", target="head", name="sheet/sheet.css"), @ResourceDependency(library="primefaces-extensions", name="sheet/sheet.js")})
public class Sheet
extends UIInput
implements ClientBehaviorHolder,
EditableValueHolder,
Widget {
    public static final String EVENT_CELL_SELECT = "cellSelect";
    public static final String EVENT_CHANGE = "change";
    public static final String EVENT_SORT = "sort";
    public static final String EVENT_FILTER = "filter";
    public static final String EVENT_COLUMN_SELECT = "columnSelect";
    public static final String EVENT_ROW_SELECT = "rowSelect";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Sheet";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.SheetRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("change", "cellSelect", "sort", "filter", "columnSelect", "rowSelect"));
    private List<SheetColumn> columns;
    private List<SheetInvalidUpdate> invalidUpdates;
    private Map<SheetRowColIndex, String> submittedValues = new HashMap<SheetRowColIndex, String>();
    private Map<SheetRowColIndex, Object> localValues = new HashMap<SheetRowColIndex, Object>();
    private String selection;
    private String focusId;
    private final List<SheetUpdate> updates = new ArrayList<SheetUpdate>();
    private Map<Integer, Integer> columnMapping;
    private Map<String, Object> rowMap;
    private Map<String, Integer> rowNumbers;

    public Sheet() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return EVENT_CHANGE;
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            SheetEvent sheetEvent = new SheetEvent((UIComponent)this, behaviorEvent.getBehavior());
            sheetEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)sheetEvent);
            return;
        }
        super.queueEvent(event);
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public String getStyleClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setStretchH(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stretchH), (Object)value);
    }

    public String getStretchH() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stretchH), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setEmptyMessage(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)value);
    }

    public String getEmptyMessage() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setShowColumnHeaders(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showColumnHeaders), (Object)value);
    }

    public Boolean isShowColumnHeaders() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showColumnHeaders), (Object)true).toString());
    }

    public void setShowRowHeaders(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showRowHeaders), (Object)value);
    }

    public Boolean isShowRowHeaders() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showRowHeaders), (Object)true).toString());
    }

    public void setResizableRows(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableRows), (Object)value);
    }

    public Boolean isResizableRows() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableRows), (Object)false).toString());
    }

    public void setResizableCols(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableCols), (Object)value);
    }

    public Boolean isResizableCols() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableCols), (Object)false).toString());
    }

    public void setMovableRows(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.movableRows), (Object)value);
    }

    public Boolean isMovableRows() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.movableRows), (Object)false).toString());
    }

    public void setMovableCols(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.movableCols), (Object)value);
    }

    public Boolean isMovableCols() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.movableCols), (Object)false).toString());
    }

    public void setRowStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)styleClass);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public String getActiveHeaderStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.activeHeaderStyleClass), null);
    }

    public void setReadOnly(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readOnly), (Object)value);
    }

    public Boolean isReadOnly() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readOnly), (Object)Boolean.FALSE).toString());
    }

    public void setActiveHeaderStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.activeHeaderStyleClass), (Object)_value);
    }

    public String getCommentedCellStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.commentedCellStyleClass), null);
    }

    public void setCommentedCellStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.commentedCellStyleClass), (Object)_value);
    }

    public String getCurrentColStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentColStyleClass), null);
    }

    public void setCurrentColStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentColStyleClass), (Object)_value);
    }

    public String getCurrentHeaderStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentHeaderStyleClass), null);
    }

    public void setCurrentHeaderStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentHeaderStyleClass), (Object)_value);
    }

    public String getCurrentRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentRowStyleClass), null);
    }

    public void setCurrentRowStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentRowStyleClass), (Object)_value);
    }

    public String getInvalidCellStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.invalidCellStyleClass), null);
    }

    public void setInvalidCellStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.invalidCellStyleClass), (Object)_value);
    }

    public String getNoWordWrapStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.noWordWrapStyleClass), null);
    }

    public void setNoWordWrapStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.noWordWrapStyleClass), (Object)_value);
    }

    public String getPlaceholderCellStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.placeholderCellStyleClass), null);
    }

    public void setPlaceholderCellStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.placeholderCellStyleClass), (Object)_value);
    }

    public String getReadOnlyCellStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.placeholderCellStyleClass), null);
    }

    public void setReadOnlyCellStyleClass(String _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readOnlyCellStyleClass), (Object)_value);
    }

    public String getExtender() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.extender), null);
    }

    public void setExtender(String _extender) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.extender), (Object)_extender);
    }

    public void setCaseSensitiveSort(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)value);
    }

    public Boolean isCaseSensitiveSort() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)Boolean.FALSE).toString());
    }

    public Integer getNullSortOrder() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nullSortOrder), (Object)1);
    }

    public void setNullSortOrder(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nullSortOrder), (Object)value);
    }

    public List<SheetColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<SheetColumn>();
            this.getColumns((UIComponent)this);
        }
        return this.columns;
    }

    private void getColumns(UIComponent parent) {
        for (UIComponent child : parent.getChildren()) {
            if (!(child instanceof SheetColumn)) continue;
            this.columns.add((SheetColumn)child);
        }
    }

    public void setColumns(List<SheetColumn> columns) {
        this.columns = columns;
    }

    public void setMaxRows(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxRows), (Object)value);
    }

    public Integer getMaxRows() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxRows), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setMinRows(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minRows), (Object)value);
    }

    public Integer getMinRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minRows), (Object)0);
    }

    public void setMaxCols(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxCols), (Object)value);
    }

    public Integer getMaxCols() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxCols), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setMinCols(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minCols), (Object)value);
    }

    public Integer getMinCols() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minCols), (Object)0);
    }

    public void setFixedRows(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fixedRows), (Object)value);
    }

    public Integer getFixedRows() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedRows), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setFixedRowsBottom(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fixedRowsBottom), (Object)value);
    }

    public Integer getFixedRowsBottom() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedRowsBottom), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setFixedCols(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fixedCols), (Object)value);
    }

    public Integer getFixedCols() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedCols), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public String getLocale() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), (Object)"en-US");
    }

    public void setLocale(String locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), (Object)locale);
    }

    public List<SheetInvalidUpdate> getInvalidUpdates() {
        if (this.invalidUpdates == null) {
            this.invalidUpdates = new ArrayList<SheetInvalidUpdate>();
        }
        return this.invalidUpdates;
    }

    public void resetSubmitted() {
        this.submittedValues.clear();
        this.updates.clear();
    }

    public void resetSort() {
        ValueExpression origSortBy = (ValueExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.origSortBy));
        this.setSortByValueExpression(origSortBy);
        String origSortOrder = (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.origSortOrder));
        if (origSortOrder != null) {
            this.setSortOrder(origSortOrder);
        }
    }

    public void resetInvalidUpdates() {
        this.getInvalidUpdates().clear();
    }

    public void reset() {
        this.resetSubmitted();
        this.resetSort();
        this.resetInvalidUpdates();
        this.localValues.clear();
        for (SheetColumn c : this.getColumns()) {
            c.setFilterValue(null);
        }
    }

    public void setSubmittedValue(FacesContext context, String rowKey, int col, String value) {
        this.submittedValues.put(new SheetRowColIndex(rowKey, col), value);
    }

    public String getSubmittedValue(String rowKey, int col) {
        return this.submittedValues.get(new SheetRowColIndex(rowKey, col));
    }

    public void setLocalValue(String rowKey, int col, Object value) {
        this.localValues.put(new SheetRowColIndex(rowKey, col), value);
    }

    public Object getLocalValue(String rowKey, int col) {
        return this.localValues.get(new SheetRowColIndex(rowKey, col));
    }

    public void setRowVar(FacesContext context, String rowKey) {
        if (context == null) {
            return;
        }
        if (rowKey == null) {
            context.getExternalContext().getRequestMap().remove(this.getVar());
        } else {
            Object value = this.getRowMap().get(rowKey);
            context.getExternalContext().getRequestMap().put(this.getVar(), value);
        }
    }

    protected Map<String, Object> getRowMap() {
        if (this.rowMap == null || this.rowMap.isEmpty()) {
            this.remapRows();
        }
        return this.rowMap;
    }

    public Object getValueForCell(FacesContext context, String rowKey, int col) {
        SheetRowColIndex index = new SheetRowColIndex(rowKey, col);
        if (this.localValues.containsKey(index)) {
            return this.localValues.get(index);
        }
        this.setRowVar(context, rowKey);
        SheetColumn column = this.getColumns().get(col);
        return column.getValueExpression("value").getValue(context.getELContext());
    }

    public String getRenderValueForCell(FacesContext context, String rowKey, int col) {
        SheetRowColIndex index = new SheetRowColIndex(rowKey, col);
        if (this.submittedValues.containsKey(index)) {
            return this.submittedValues.get(index);
        }
        Object value = this.getValueForCell(context, rowKey, col);
        if (value == null) {
            return null;
        }
        SheetColumn column = this.getColumns().get(col);
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)column);
        if (converter == null) {
            return value.toString();
        }
        return converter.getAsString(context, (UIComponent)this, value);
    }

    public Integer getSelectedColumn() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedColumn));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setSelectedColumn(Integer col) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedColumn), (Object)col);
    }

    public Integer getSelectedLastColumn() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedLastColumn));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setSelectedLastColumn(Integer col) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedLastColumn), (Object)col);
    }

    public Integer getSelectedRow() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedRow));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public Integer getSelectedLastRow() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedLastRow));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setSelectedRow(Integer row) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedRow), (Object)row);
    }

    public void setSelectedLastRow(Integer row) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedLastRow), (Object)row);
    }

    public Integer getWidth() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setWidth(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), (Object)value);
    }

    public Integer getHeight() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setHeight(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)value);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public List getFilteredValue() {
        return (List)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filteredValue), new ArrayList());
    }

    public void setFilteredValue(List _filteredValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filteredValue), (Object)_filteredValue);
    }

    public void setValue(Object value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    public void setStyle(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)value);
    }

    public String getStyle() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    protected ValueExpression getRowHeaderValueExpression() {
        return this.getValueExpression(PropertyKeys.rowHeader.name());
    }

    protected String getRowHeaderValueAsString(FacesContext context) {
        ValueExpression veRowHeader = this.getRowHeaderValueExpression();
        Object value = veRowHeader.getValue(context.getELContext());
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public List<Object> getSortedValues() {
        List<Object> filtered = this.getFilteredValue();
        if (filtered == null || filtered.isEmpty()) {
            filtered = this.sortAndFilter();
        }
        return filtered;
    }

    public int getSortColRenderIndex() {
        ValueExpression veSortBy = this.getValueExpression(PropertyKeys.sortBy.name());
        if (veSortBy == null) {
            return -1;
        }
        String sortByExp = veSortBy.getExpressionString();
        int colIdx = 0;
        for (SheetColumn column : this.getColumns()) {
            if (!column.isRendered()) continue;
            ValueExpression veCol = column.getValueExpression(PropertyKeys.sortBy.name());
            if (veCol != null && veCol.getExpressionString().equals(sortByExp)) {
                return colIdx;
            }
            ++colIdx;
        }
        return -1;
    }

    protected boolean matchesFilter(Object obj) {
        block10: for (SheetColumn col : this.getColumns()) {
            String filterValue = col.getFilterValue();
            if (StringUtils.isEmpty((CharSequence)filterValue)) continue;
            Object filterBy = col.getFilterBy();
            if (filterBy == null) {
                return false;
            }
            String filterMatchMode = col.getFilterMatchMode();
            if (StringUtils.isEmpty((CharSequence)filterMatchMode)) {
                filterMatchMode = "contains";
            }
            String value = filterBy.toString().toLowerCase();
            String filter = filterValue.toLowerCase();
            switch (filterMatchMode) {
                case "startsWith": {
                    if (value.startsWith(filter)) continue block10;
                    return false;
                }
                case "endsWith": {
                    if (value.endsWith(filter)) continue block10;
                    return false;
                }
                case "exact": {
                    if (value.equals(filter)) continue block10;
                    return false;
                }
            }
            if (value.contains(filter)) continue;
            return false;
        }
        return true;
    }

    public List<Object> sortAndFilter() {
        List filteredList = this.getFilteredValue();
        filteredList.clear();
        this.rowMap = new HashMap<String, Object>();
        this.rowNumbers = new HashMap<String, Integer>();
        Collection values = (Collection)this.getValue();
        if (values == null || values.isEmpty()) {
            return filteredList;
        }
        this.remapRows();
        boolean filters = false;
        for (SheetColumn col : this.getColumns()) {
            if (!StringUtils.isNotEmpty((CharSequence)col.getFilterValue())) continue;
            filters = true;
            break;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String var = this.getVar();
        if (filters) {
            for (Object obj : values) {
                requestMap.put(var, obj);
                if (!this.matchesFilter(obj)) continue;
                filteredList.add(obj);
            }
        } else {
            filteredList.addAll(values);
        }
        ValueExpression veSortBy = this.getValueExpression(PropertyKeys.sortBy.name());
        if (veSortBy != null) {
            Collections.sort(filteredList, new BeanPropertyComparator(veSortBy, var, this.convertSortOrder(), null, this.isCaseSensitiveSort().booleanValue(), Locale.ENGLISH, this.getNullSortOrder().intValue()));
        }
        this.remapFilteredList(filteredList);
        return filteredList;
    }

    protected void remapFilteredList(List filteredList) {
        this.rowNumbers = new HashMap<String, Integer>(this.rowMap.size());
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String var = this.getVar();
        int row = 0;
        for (Object value : filteredList) {
            requestMap.put(var, value);
            this.rowNumbers.put(this.getRowKeyValueAsString(context), row);
            ++row;
        }
        requestMap.remove(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remapRows() {
        this.rowMap = new HashMap<String, Object>();
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        Collection values = (Collection)this.getValue();
        String var = this.getVar();
        for (Object obj : values) {
            requestMap.put(var, obj);
            try {
                String key = this.getRowKeyValueAsString(context);
                this.rowMap.put(key, obj);
            }
            finally {
                requestMap.remove(var);
            }
        }
    }

    protected Object getRowKeyValue(FacesContext context) {
        ValueExpression veRowKey = this.getValueExpression(PropertyKeys.rowKey.name());
        if (veRowKey == null) {
            throw new RuntimeException("RowKey required on sheet!");
        }
        Object value = veRowKey.getValue(context.getELContext());
        if (value == null) {
            throw new RuntimeException("RowKey must resolve to non-null value for updates to work properly");
        }
        return value;
    }

    protected String getRowKeyValueAsString(Object key) {
        String result = key.toString();
        return "r_" + StringUtils.deleteWhitespace((String)result);
    }

    protected String getRowKeyValueAsString(FacesContext context) {
        return this.getRowKeyValueAsString(this.getRowKeyValue(context));
    }

    protected SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        SortOrder result = SortOrder.valueOf((String)sortOrder.toUpperCase(Locale.ENGLISH));
        return result;
    }

    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)var);
    }

    public ValueExpression getSortByValueExpression() {
        ValueExpression veSortBy = this.getValueExpression(PropertyKeys.sortBy.name());
        return veSortBy;
    }

    public void setSortByValueExpression(ValueExpression sortBy) {
        this.setValueExpression(PropertyKeys.sortBy.name(), sortBy);
    }

    public String getSortOrder() {
        String result = (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)SortOrder.ASCENDING.toString());
        return result;
    }

    public void setSortOrder(String sortOrder) {
        String orig = (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.origSortOrder));
        if (orig == null) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.origSortOrder), this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder)));
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)sortOrder);
    }

    public String getErrorMessage() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.errorMessage));
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setErrorMessage(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.errorMessage), (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(FacesContext context) {
        Iterator<Map.Entry<SheetRowColIndex, String>> entries = this.submittedValues.entrySet().iterator();
        boolean hadBadUpdates = !this.getInvalidUpdates().isEmpty();
        this.getInvalidUpdates().clear();
        while (entries.hasNext()) {
            Map.Entry<SheetRowColIndex, String> entry = entries.next();
            SheetColumn column = this.getColumns().get(entry.getKey().getColIndex());
            String newValue = entry.getValue();
            String rowKey = entry.getKey().getRowKey();
            int col = entry.getKey().getColIndex();
            this.setRowVar(context, rowKey);
            Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)column);
            Object newValueObj = newValue;
            if (converter != null) {
                try {
                    newValueObj = converter.getAsObject(context, (UIComponent)this, newValue);
                }
                catch (ConverterException e) {
                    this.setValid(false);
                    FacesMessage message = e.getFacesMessage();
                    if (message == null) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), e.getMessage());
                    }
                    context.addMessage(this.getClientId(context), message);
                    String messageText = message.getDetail();
                    this.getInvalidUpdates().add(new SheetInvalidUpdate(this.getRowKeyValue(context), col, column, newValue, messageText));
                    continue;
                }
            }
            this.setLocalValue(rowKey, col, newValueObj);
            column.setValue(newValueObj);
            try {
                column.validate(context);
            }
            finally {
                column.resetValue();
            }
            entries.remove();
        }
        this.setRowVar(context, null);
        boolean newBadUpdates = !this.getInvalidUpdates().isEmpty();
        String errorMessage = this.getErrorMessage();
        if ((hadBadUpdates || newBadUpdates) && context.getPartialViewContext().isPartialRequest()) {
            this.renderBadUpdateScript(context);
        }
        if (newBadUpdates && errorMessage != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage);
            context.addMessage(null, message);
        }
    }

    public void updateModel(FacesContext context) {
        Iterator<Map.Entry<SheetRowColIndex, Object>> entries = this.localValues.entrySet().iterator();
        HashSet<String> dirtyRows = new HashSet<String>();
        while (entries.hasNext()) {
            Map.Entry<SheetRowColIndex, Object> entry = entries.next();
            Object newValue = entry.getValue();
            String rowKey = entry.getKey().getRowKey();
            int col = entry.getKey().getColIndex();
            SheetColumn column = this.getColumns().get(col);
            this.setRowVar(context, rowKey);
            Object rowVal = this.rowMap.get(rowKey);
            ValueExpression ve = column.getValueExpression(PropertyKeys.value.name());
            ELContext elContext = context.getELContext();
            Object oldValue = ve.getValue(elContext);
            ve.setValue(elContext, newValue);
            entries.remove();
            this.appendUpdateEvent(this.getRowKeyValue(context), col, rowVal, oldValue, newValue);
            dirtyRows.add(rowKey);
        }
        this.setLocalValueSet(false);
        this.setRowVar(context, null);
        if (context.getPartialViewContext().isPartialRequest()) {
            this.renderRowUpdateScript(context, dirtyRows);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.submittedValues, this.localValues, this.invalidUpdates, this.columnMapping, this.getFilteredValue(), this.rowMap, this.rowNumbers};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        Object restoredSubmittedValues = values[1];
        Object restoredLocalValues = values[2];
        Object restoredInvalidUpdates = values[3];
        Object restoredColMappings = values[4];
        Object restoredSortedList = values[5];
        Object restoredRowMap = values[6];
        Object restoredRowNumbers = values[7];
        if (restoredSubmittedValues == null) {
            this.submittedValues.clear();
        } else {
            this.submittedValues = (Map)restoredSubmittedValues;
        }
        if (restoredLocalValues == null) {
            this.localValues.clear();
        } else {
            this.localValues = (Map)restoredLocalValues;
        }
        if (restoredInvalidUpdates == null) {
            this.getInvalidUpdates().clear();
        } else {
            this.invalidUpdates = (List)restoredInvalidUpdates;
        }
        this.columnMapping = restoredColMappings == null ? null : (Map)restoredColMappings;
        if (restoredSortedList == null) {
            this.getFilteredValue().clear();
        } else {
            this.setFilteredValue((List)restoredSortedList);
        }
        this.rowMap = restoredRowMap == null ? null : (Map)restoredRowMap;
        this.rowNumbers = restoredRowNumbers == null ? null : (Map)restoredRowNumbers;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public Object getSubmittedValue() {
        if (this.submittedValues.isEmpty()) {
            return null;
        }
        return this.submittedValues;
    }

    public void setSubmittedValue(Object submittedValue) {
        if (submittedValue == null) {
            this.submittedValues.clear();
        } else {
            this.submittedValues = (Map)submittedValue;
        }
    }

    public List<SheetUpdate> getUpdates() {
        return this.updates;
    }

    public boolean isHasStyledCells() {
        for (SheetColumn column : this.getColumns()) {
            if (column.getStyleClass() == null) continue;
            return true;
        }
        return false;
    }

    public int getMappedColumn(int renderIdx) {
        if (this.columnMapping == null || renderIdx == -1) {
            return renderIdx;
        }
        Integer result = this.columnMapping.get(renderIdx);
        if (result == null) {
            throw new IllegalArgumentException("Invalid index " + renderIdx);
        }
        return result;
    }

    public int getRenderIndexFromRealIdx(int realIdx) {
        if (this.columnMapping == null || realIdx == -1) {
            return realIdx;
        }
        for (Map.Entry<Integer, Integer> entry : this.columnMapping.entrySet()) {
            if (!entry.getValue().equals(realIdx)) continue;
            return entry.getKey();
        }
        return realIdx;
    }

    public void updateColumnMappings() {
        this.columnMapping = new HashMap<Integer, Integer>();
        int realIdx = 0;
        int renderIdx = 0;
        for (SheetColumn column : this.getColumns()) {
            if (column.isRendered()) {
                this.columnMapping.put(renderIdx, realIdx);
                ++renderIdx;
            }
            ++realIdx;
        }
    }

    public int getRowCount() {
        List<Object> values = this.getSortedValues();
        if (values == null) {
            return 0;
        }
        return values.size();
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public void commitUpdates() {
        this.resetSubmitted();
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext().isPartialRequest()) {
            StringBuilder eval = new StringBuilder();
            String jsVar = this.resolveWidgetVar();
            eval.append("PF('").append(jsVar).append("')").append(".clearDataInput();");
            RequestContext.getCurrentInstance().getScriptsToExecute().add(eval.toString());
        }
    }

    public String getInvalidDataValue() {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, true);
        for (SheetInvalidUpdate sheetInvalidUpdate : this.getInvalidUpdates()) {
            Object rowKey = sheetInvalidUpdate.getInvalidRowKey();
            int col = this.getRenderIndexFromRealIdx(sheetInvalidUpdate.getInvalidColIndex());
            String rowKeyProperty = this.getRowKeyValueAsString(rowKey);
            vb.appendProperty(rowKeyProperty + "_c" + col, sheetInvalidUpdate.getInvalidMessage().replace("'", "&apos;"), true);
        }
        return vb.closeVar().toString();
    }

    public void renderRowUpdateScript(FacesContext context, Set<String> dirtyRows) {
        String jsVar = this.resolveWidgetVar();
        StringBuilder eval = new StringBuilder();
        for (String rowKey : dirtyRows) {
            this.setRowVar(context, rowKey);
            int rowIndex = this.rowNumbers.get(rowKey);
            JavascriptVarBuilder jsRow = new JavascriptVarBuilder(null, false);
            JavascriptVarBuilder jsStyle = new JavascriptVarBuilder(null, true);
            JavascriptVarBuilder jsReadOnly = new JavascriptVarBuilder(null, true);
            for (int col = 0; col < this.getColumns().size(); ++col) {
                boolean readOnly;
                SheetColumn column = this.getColumns().get(col);
                if (!column.isRendered()) continue;
                String value = this.getRenderValueForCell(context, rowKey, col);
                jsRow.appendArrayValue(value, true);
                String styleClass = column.getStyleClass();
                if (styleClass != null) {
                    jsStyle.appendRowColProperty(rowIndex, col, styleClass, true);
                }
                if (!(readOnly = column.isReadonlyCell().booleanValue())) continue;
                jsReadOnly.appendRowColProperty(rowIndex, col, "true", true);
            }
            eval.append("PF('").append(jsVar).append("')");
            eval.append(".updateData('");
            eval.append(rowIndex);
            eval.append("',");
            eval.append(jsRow.closeVar().toString());
            eval.append(",");
            eval.append(jsStyle.closeVar().toString());
            eval.append(",");
            eval.append(jsReadOnly.closeVar().toString());
            eval.append(");");
        }
        eval.append("PF('").append(jsVar).append("')").append(".redraw();");
        RequestContext.getCurrentInstance().getScriptsToExecute().add(eval.toString());
    }

    public void renderBadUpdateScript(FacesContext context) {
        String widgetVar = this.resolveWidgetVar();
        String invalidValue = this.getInvalidDataValue();
        StringBuilder sb = new StringBuilder("PF('" + widgetVar + "')");
        sb.append(".cfg.errors=");
        sb.append(invalidValue);
        sb.append(";");
        sb.append("PF('" + widgetVar + "')");
        sb.append(".ht.render();");
        RequestContext.getCurrentInstance().getScriptsToExecute().add(sb.toString());
        sb = new StringBuilder();
        sb.append("PF('").append(widgetVar).append("')");
        sb.append(".sheetDiv.removeClass('ui-state-error')");
        if (!this.getInvalidUpdates().isEmpty()) {
            sb.append(".addClass('ui-state-error')");
        }
        RequestContext.getCurrentInstance().getScriptsToExecute().add(sb.toString());
    }

    public void appendUpdateEvent(Object rowKey, int colIndex, Object rowData, Object oldValue, Object newValue) {
        this.updates.add(new SheetUpdate(rowKey, colIndex, rowData, oldValue, newValue));
    }

    static enum PropertyKeys {
        value,
        filteredValue,
        valid,
        var,
        locale,
        selectedRow,
        selectedLastRow,
        selectedColumn,
        selectedLastColumn,
        showColumnHeaders,
        showRowHeaders,
        rowHeader,
        maxRows,
        minRows,
        maxCols,
        minCols,
        fixedRows,
        fixedRowsBottom,
        fixedCols,
        resizableRows,
        resizableCols,
        movableRows,
        movableCols,
        width,
        height,
        errorMessage,
        style,
        styleClass,
        rowKey,
        sortBy,
        sortOrder,
        nullSortOrder,
        caseSensitiveSort,
        origSortBy,
        origSortOrder,
        stretchH,
        rowStyleClass,
        readOnly,
        emptyMessage,
        activeHeaderStyleClass,
        commentedCellStyleClass,
        currentColStyleClass,
        currentHeaderStyleClass,
        currentRowStyleClass,
        invalidCellStyleClass,
        noWordWrapStyleClass,
        placeholderCellStyleClass,
        readOnlyCellStyleClass,
        extender;

    }
}

