/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.fluidgrid;

import java.io.IOException;
import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.fluidgrid.FluidGrid;
import org.primefaces.extensions.component.fluidgrid.UIFluidGridItem;
import org.primefaces.extensions.model.fluidgrid.FluidGridItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class FluidGridRenderer
extends CoreRenderer {
    private static final String GRID_CLASS = "pe-fluidgrid";
    private static final String GRID_ITEM_CLASS = "pe-fluidgrid-item";
    private static final String LIST_ROLE = "list";
    private static final String LIST_ITEM_ROLE = "listitem";

    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        FluidGrid fluidGrid = (FluidGrid)component;
        this.encodeMarkup(fc, fluidGrid);
        this.encodeScript(fc, fluidGrid);
    }

    protected void encodeMarkup(FacesContext fc, FluidGrid fluidGrid) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = fluidGrid.getClientId(fc);
        String styleClass = fluidGrid.getStyleClass();
        styleClass = styleClass == null ? GRID_CLASS : "pe-fluidgrid " + styleClass;
        writer.startElement("div", (UIComponent)fluidGrid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (fluidGrid.getStyle() != null) {
            writer.writeAttribute("style", (Object)fluidGrid.getStyle(), "style");
        }
        writer.writeAttribute("role", (Object)LIST_ROLE, null);
        if (fluidGrid.getVar() != null) {
            Object value = fluidGrid.getValue();
            if (value != null) {
                if (!(value instanceof Collection)) {
                    throw new FacesException("Value in FluidGrid must be of type Collection / List");
                }
                for (UIComponent kid : fluidGrid.getChildren()) {
                    if (!kid.isRendered() || kid instanceof UIFluidGridItem) continue;
                    this.renderChild(fc, kid);
                }
                Collection col = (Collection)value;
                for (FluidGridItem fluidGridItem : col) {
                    UIFluidGridItem uiItem = fluidGrid.getItem(fluidGridItem.getType());
                    if (!uiItem.isRendered()) continue;
                    fluidGrid.setData(fluidGridItem);
                    this.renderItem(fc, writer, fluidGrid, uiItem);
                }
            }
        } else {
            for (UIComponent kid : fluidGrid.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof UIFluidGridItem) {
                    this.renderItem(fc, writer, fluidGrid, (UIFluidGridItem)kid);
                    continue;
                }
                this.renderChild(fc, kid);
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext fc, FluidGrid fluidGrid) throws IOException {
        String stamp;
        String clientId = fluidGrid.getClientId(fc);
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.initWithDomReady("ExtFluidGrid", fluidGrid.resolveWidgetVar(), clientId);
        wb.append(",opts:{");
        wb.append("isFitWidth:" + fluidGrid.isFitWidth());
        wb.append(",isOriginLeft:" + fluidGrid.isOriginLeft());
        wb.append(",isOriginTop:" + fluidGrid.isOriginTop());
        wb.append(",isResizeBound:" + fluidGrid.isResizeBound());
        wb.append(",hasImages:" + fluidGrid.isHasImages());
        if (fluidGrid.gethGutter() != 0) {
            wb.append(",gutter:" + fluidGrid.gethGutter());
        }
        if ((stamp = SearchExpressionFacade.resolveClientIds((FacesContext)fc, (UIComponent)fluidGrid, (String)fluidGrid.getStamp())) != null) {
            wb.append(",stamp:'" + stamp + "'");
        }
        if (fluidGrid.getTransitionDuration() != null) {
            wb.append(",transitionDuration:'" + fluidGrid.getTransitionDuration() + "'");
        } else {
            wb.append(",transitionDuration:0");
        }
        wb.append("}");
        this.encodeClientBehaviors(fc, fluidGrid);
        wb.finish();
    }

    protected void renderItem(FacesContext fc, ResponseWriter writer, FluidGrid fluidGrid, UIFluidGridItem uiItem) throws IOException {
        writer.startElement("div", null);
        if (uiItem.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)("pe-fluidgrid-item " + uiItem.getStyleClass()), null);
        } else {
            writer.writeAttribute("class", (Object)GRID_ITEM_CLASS, null);
        }
        if (fluidGrid.getvGutter() != 0) {
            writer.writeAttribute("style", (Object)("margin-bottom: " + fluidGrid.getvGutter() + "px"), null);
        }
        writer.writeAttribute("role", (Object)LIST_ITEM_ROLE, null);
        uiItem.encodeAll(fc);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

