/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.calculator;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.api.RTLAware;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.calculator.Calculator;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class CalculatorRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Calculator calculator = (Calculator)component;
        this.encodeScript(context, calculator);
    }

    private void encodeScript(FacesContext context, Calculator calculator) throws IOException {
        UIComponent targetComponent;
        String target = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)calculator, (String)calculator.getFor());
        if (this.isValueBlank(target)) {
            target = calculator.getParent().getClientId(context);
        }
        if (!((targetComponent = SearchExpressionFacade.resolveComponent((FacesContext)context, (UIComponent)calculator, (String)target)) instanceof UIInput)) {
            throw new FacesException("Calculator must use for=\"target\" or be nested inside an input!");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("ExtCalculator", calculator.resolveWidgetVar(), calculator.getClientId(context));
        wb.attr("target", target);
        wb.attr("showOn", StringUtils.lowerCase((String)calculator.getShowOn()));
        wb.attr("layout", StringUtils.lowerCase((String)calculator.getLayout()));
        wb.attr("precision", (Number)calculator.getPrecision());
        wb.attr("locale", calculator.calculateLocale().toString());
        wb.attr("isRTL", Boolean.valueOf(ComponentUtils.isRTL((FacesContext)context, (RTLAware)calculator)));
        wb.attr("calculatorClass", calculator.getStyleClass());
        if (calculator.getOnopen() != null) {
            wb.callback("onOpen", "function(value, inst)", calculator.getOnopen());
        }
        if (calculator.getOnclose() != null) {
            wb.callback("onClose", "function(value, inst)", calculator.getOnclose());
        }
        if (calculator.getOnbutton() != null) {
            wb.callback("onButton", "function(label, value, inst)", calculator.getOnbutton());
        }
        this.encodeClientBehaviors(context, calculator);
        wb.finish();
    }
}

