/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.codemirror;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.CompleteEvent;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="codemirror/codemirror.js"), @ResourceDependency(library="primefaces-extensions", name="codemirror/codemirror.css")})
public class CodeMirror
extends HtmlInputTextarea
implements ClientBehaviorHolder,
Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.CodeMirror";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String EVENT_CHANGE = "change";
    public static final String EVENT_HIGHLIGHT_COMPLETE = "highlightComplete";
    public static final String EVENT_BLUR = "blur";
    public static final String EVENT_FOCUS = "focus";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.CodeMirrorRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("change", "highlightComplete", "blur", "focus", "change"));
    private List<String> suggestions = null;

    public CodeMirror() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.theme), null);
    }

    public void setTheme(String theme) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.theme), (Object)theme);
    }

    public String getMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mode), null);
    }

    public void setMode(String mode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mode), (Object)mode);
    }

    public String getKeyMap() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.keyMap), null);
    }

    public void setKeyMap(String keyMap) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.keyMap), (Object)keyMap);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public Integer getIndentUnit() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.indentUnit), null);
    }

    public void setIndentUnit(Integer indentUnit) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.indentUnit), (Object)indentUnit);
    }

    public Integer getTabSize() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabSize), null);
    }

    public void setFirstLineNumber(Integer firstLineNumber) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.firstLineNumber), (Object)firstLineNumber);
    }

    public Integer getFirstLineNumber() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.firstLineNumber), null);
    }

    public void setTabSize(Integer tabSize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabSize), (Object)tabSize);
    }

    public Boolean isLineNumbers() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lineNumbers), null);
    }

    public void setLineNumbers(Boolean lineNumbers) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lineNumbers), (Object)lineNumbers);
    }

    public Boolean isSmartIndent() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.smartIndent), null);
    }

    public void setSmartIndent(Boolean smartIndent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.smartIndent), (Object)smartIndent);
    }

    public boolean isReadonly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonly), (Object)false);
    }

    public void setReadonly(boolean readonly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonly), (Object)readonly);
    }

    public Boolean isIndentWithTabs() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.indentWithTabs), null);
    }

    public void setIndentWithTabs(Boolean indentWithTabs) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.indentWithTabs), (Object)indentWithTabs);
    }

    public Boolean isElectricChars() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.electricChars), null);
    }

    public void setElectricChars(Boolean electricChars) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.electricChars), (Object)electricChars);
    }

    public Boolean isLineWrapping() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lineWrapping), null);
    }

    public void setLineWrapping(Boolean lineWrapping) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lineWrapping), (Object)lineWrapping);
    }

    public Boolean isGutter() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.gutter), null);
    }

    public void setGutter(Boolean gutter) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.gutter), (Object)gutter);
    }

    public Boolean isFixedGutter() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedGutter), null);
    }

    public void setFixedGutter(Boolean fixedGutter) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fixedGutter), (Object)fixedGutter);
    }

    public Boolean isMatchBrackets() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.matchBrackets), null);
    }

    public void setMatchBrackets(Boolean matchBrackets) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.matchBrackets), (Object)matchBrackets);
    }

    public Integer getWorkTime() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.workTime), null);
    }

    public void setWorkTime(Integer workTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.workTime), (Object)workTime);
    }

    public Integer getWorkDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.workDelay), null);
    }

    public void setWorkDelay(Integer workDelay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.workDelay), (Object)workDelay);
    }

    public Integer getPollInterval() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pollInterval), null);
    }

    public void setPollInterval(Integer pollInterval) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pollInterval), (Object)pollInterval);
    }

    public Integer getUndoDepth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.undoDepth), null);
    }

    public void setUndoDepth(Integer undoDepth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.undoDepth), (Object)undoDepth);
    }

    public String getTabindex() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), null);
    }

    public void setTabindex(String tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), (Object)tabindex);
    }

    public String getExtraKeys() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.extraKeys), null);
    }

    public void setExtraKeys(String extraKeys) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.extraKeys), (Object)extraKeys);
    }

    public MethodExpression getCompleteMethod() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.completeMethod), null);
    }

    public void setCompleteMethod(MethodExpression completeMethod) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.completeMethod), (Object)completeMethod);
    }

    public String getProcess() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.process), null);
    }

    public void setProcess(String process) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.process), (Object)process);
    }

    public String getOnstart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onstart), null);
    }

    public void setOnstart(String onstart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onstart), (Object)onstart);
    }

    public String getOncomplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.oncomplete), null);
    }

    public void setOncomplete(String oncomplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.oncomplete), (Object)oncomplete);
    }

    public String getOnerror() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onerror), null);
    }

    public void setOnerror(String onerror) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onerror), (Object)onerror);
    }

    public String getOnsuccess() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onsuccess), null);
    }

    public void setOnsuccess(String onsuccess) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onsuccess), (Object)onsuccess);
    }

    public boolean isGlobal() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.global), (Object)true);
    }

    public void setGlobal(boolean global) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.global), (Object)global);
    }

    public boolean isAsync() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.async), (Object)false);
    }

    public void setAsync(boolean async) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.async), (Object)async);
    }

    public boolean isEscape() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.escape), (Object)true);
    }

    public void setEscape(boolean escape) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.escape), (Object)escape);
    }

    public boolean isEscapeSuggestions() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.escapeSuggestions), (Object)true);
    }

    public void setEscapeSuggestions(boolean suggestions) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.escapeSuggestions), (Object)suggestions);
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MethodExpression completeMethod = this.getCompleteMethod();
        if (completeMethod != null && event instanceof CompleteEvent) {
            this.suggestions = (List)completeMethod.invoke(facesContext.getELContext(), new Object[]{event});
            if (this.suggestions == null) {
                this.suggestions = new ArrayList<String>();
            }
            facesContext.renderResponse();
        }
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    protected static enum PropertyKeys {
        widgetVar,
        theme,
        mode,
        indentUnit,
        smartIndent,
        tabSize,
        indentWithTabs,
        electricChars,
        keyMap,
        lineWrapping,
        lineNumbers,
        firstLineNumber,
        gutter,
        fixedGutter,
        readonly,
        matchBrackets,
        workTime,
        workDelay,
        pollInterval,
        undoDepth,
        tabindex,
        extraKeys,
        completeMethod,
        process,
        onstart,
        oncomplete,
        onerror,
        onsuccess,
        global,
        async,
        escape,
        escapeSuggestions;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

