/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.sheet.Sheet;
import org.primefaces.extensions.component.sheet.SheetColumn;
import org.primefaces.extensions.util.JavascriptVarBuilder;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SheetRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        Sheet sheet = (Sheet)component;
        sheet.updateColumnMappings();
        sheet.sortAndFilter();
        this.encodeMarkup(context, sheet, responseWriter);
        this.encodeScript(context, sheet, responseWriter);
    }

    protected void encodeMarkup(FacesContext context, Sheet sheet, ResponseWriter responseWriter) throws IOException {
        String styleClass = sheet.getStyleClass();
        String clientId = sheet.getClientId(context);
        Integer width = sheet.getWidth();
        Integer height = sheet.getHeight();
        String style = sheet.getStyle();
        responseWriter.startElement("div", null);
        responseWriter.writeAttribute("id", (Object)clientId, "id");
        responseWriter.writeAttribute("name", (Object)clientId, "clientId");
        String divclass = "ui-handsontable ui-widget";
        if (styleClass != null) {
            divclass = divclass + " " + styleClass;
        }
        if (!sheet.isValid()) {
            divclass = divclass + " ui-state-error";
        }
        responseWriter.writeAttribute("class", (Object)divclass, "styleClass");
        if (width != null) {
            responseWriter.writeAttribute("style", (Object)("width: " + width + "px;"), null);
        }
        this.encodeHiddenInputs(responseWriter, sheet, clientId);
        this.encodeFilterValues(context, responseWriter, sheet, clientId);
        this.encodeHeader(context, responseWriter, sheet);
        responseWriter.startElement("div", null);
        responseWriter.writeAttribute("id", (Object)(clientId + "_tbl"), "id");
        responseWriter.writeAttribute("name", (Object)(clientId + "_tbl"), "clientId");
        responseWriter.writeAttribute("class", (Object)"handsontable-inner", "styleClass");
        if (style == null) {
            style = "";
        }
        if (width != null) {
            style = style + "width: " + width + "px;";
        }
        if ((style = height != null ? style + "height: " + height + "px;" : style + "height: 100%;").length() > 0) {
            responseWriter.writeAttribute("style", (Object)style, null);
        }
        responseWriter.endElement("div");
        this.encodeFooter(context, responseWriter, sheet);
        responseWriter.endElement("div");
    }

    protected void encodeOptionalAttr(WidgetBuilder wb, String attrName, String value) throws IOException {
        if (value != null) {
            wb.attr(attrName, value);
        }
    }

    protected void encodeOptionalNativeAttr(WidgetBuilder wb, String attrName, Object value) throws IOException {
        if (value != null) {
            wb.nativeAttr(attrName, value.toString());
        }
    }

    protected void encodeScript(FacesContext context, Sheet sheet, ResponseWriter responseWriter) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        String clientId = sheet.getClientId(context);
        wb.initWithDomReady("ExtSheet", sheet.resolveWidgetVar(), clientId);
        this.encodeInvalidData(context, sheet, wb);
        this.encodeData(context, sheet, wb);
        wb.nativeAttr("delta", "{}");
        this.encodeFilterVar(context, sheet, wb);
        this.encodeSortVar(context, sheet, wb);
        this.encodeBehaviors(context, sheet, wb);
        this.encodeOptionalNativeAttr(wb, "readOnly", sheet.isReadOnly());
        this.encodeOptionalNativeAttr(wb, "fixedColumnsLeft", sheet.getFixedCols());
        this.encodeOptionalNativeAttr(wb, "fixedRowsTop", sheet.getFixedRows());
        this.encodeOptionalNativeAttr(wb, "manualColumnResize", sheet.isResizableCols());
        this.encodeOptionalNativeAttr(wb, "manualRowResize", sheet.isResizableRows());
        this.encodeOptionalNativeAttr(wb, "manualColumnMove", sheet.isMovableCols());
        this.encodeOptionalNativeAttr(wb, "manualRowMove", sheet.isMovableRows());
        this.encodeOptionalNativeAttr(wb, "width", sheet.getWidth());
        this.encodeOptionalNativeAttr(wb, "height", sheet.getHeight());
        this.encodeOptionalNativeAttr(wb, "minRows", sheet.getMinRows());
        this.encodeOptionalNativeAttr(wb, "minCols", sheet.getMinCols());
        this.encodeOptionalNativeAttr(wb, "maxRows", sheet.getMaxRows());
        this.encodeOptionalNativeAttr(wb, "maxCols", sheet.getMaxCols());
        this.encodeOptionalAttr(wb, "stretchH", sheet.getStretchH());
        this.encodeOptionalAttr(wb, "activeHeaderClassName", sheet.getActiveHeaderStyleClass());
        this.encodeOptionalAttr(wb, "commentedCellClassName", sheet.getCommentedCellStyleClass());
        this.encodeOptionalAttr(wb, "currentRowClassName", sheet.getCurrentRowStyleClass());
        this.encodeOptionalAttr(wb, "currentColClassName", sheet.getCurrentColStyleClass());
        this.encodeOptionalAttr(wb, "currentHeaderClassName", sheet.getCurrentHeaderStyleClass());
        this.encodeOptionalAttr(wb, "invalidCellClassName", sheet.getInvalidCellStyleClass());
        this.encodeOptionalAttr(wb, "noWordWrapClassName", sheet.getNoWordWrapStyleClass());
        this.encodeOptionalAttr(wb, "placeholderCellClassName", sheet.getPlaceholderCellStyleClass());
        this.encodeOptionalAttr(wb, "readOnlyCellClassName", sheet.getReadOnlyCellStyleClass());
        this.encodeOptionalNativeAttr(wb, "extender", sheet.getExtender());
        String emptyMessage = sheet.getEmptyMessage();
        if (StringUtils.isEmpty((CharSequence)emptyMessage)) {
            emptyMessage = "No Records Found";
        }
        this.encodeOptionalAttr(wb, "emptyMessage", emptyMessage);
        this.encodeColHeaders(context, sheet, wb);
        this.encodeColOptions(context, sheet, wb);
        wb.finish();
    }

    protected void encodeInvalidData(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        wb.attr("errors", sheet.getInvalidDataValue());
    }

    protected void encodeColHeaders(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, false);
        for (SheetColumn column : sheet.getColumns()) {
            if (!column.isRendered()) continue;
            vb.appendArrayValue(column.getHeaderText(), true);
        }
        wb.nativeAttr("colHeaders", vb.closeVar().toString());
    }

    protected void encodeColOptions(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, false);
        for (SheetColumn column : sheet.getColumns()) {
            String validateFunction;
            if (!column.isRendered()) continue;
            JavascriptVarBuilder options = new JavascriptVarBuilder(null, true);
            options.appendProperty("type", column.getColType(), true);
            options.appendProperty("copyable", "true", false);
            Integer width = column.getColWidth();
            String calculatedWidth = null;
            if (width != null) {
                calculatedWidth = width.toString();
            }
            if (!column.isVisible().booleanValue()) {
                calculatedWidth = "0.1";
            }
            if (calculatedWidth != null) {
                options.appendProperty("width", calculatedWidth, false);
            }
            if (column.isReadonly().booleanValue()) {
                options.appendProperty("readOnly", "true", false);
            }
            if ((validateFunction = column.getOnvalidate()) != null) {
                boolean quoted = false;
                switch (validateFunction) {
                    case "autocomplete": 
                    case "date": 
                    case "numeric": 
                    case "time": {
                        quoted = true;
                        break;
                    }
                    default: {
                        quoted = false;
                    }
                }
                options.appendProperty("validator", validateFunction, quoted);
            }
            switch (column.getColType()) {
                case "password": {
                    String passwordSymbol;
                    Integer passwordLength = column.getPasswordHashLength();
                    if (passwordLength != null) {
                        options.appendProperty("hashLength", passwordLength.toString(), false);
                    }
                    if ((passwordSymbol = column.getPasswordHashSymbol()) == null) break;
                    options.appendProperty("hashSymbol", passwordSymbol, true);
                    break;
                }
                case "numeric": {
                    String culture;
                    JavascriptVarBuilder numeric = new JavascriptVarBuilder(null, true);
                    String pattern = column.getNumericPattern();
                    if (pattern != null) {
                        numeric.appendProperty("pattern", pattern, true);
                    }
                    if ((culture = column.getNumericLocale()) != null) {
                        numeric.appendProperty("culture", culture, true);
                    }
                    options.appendProperty("numericFormat", numeric.closeVar().toString(), false);
                    break;
                }
                case "date": {
                    options.appendProperty("dateFormat", column.getDateFormat(), true);
                    options.appendProperty("correctFormat", "true", false);
                    String dateConfig = column.getDatePickerConfig();
                    if (dateConfig == null) break;
                    options.appendProperty("datePickerConfig", dateConfig, false);
                    break;
                }
                case "time": {
                    options.appendProperty("timeFormat", column.getTimeFormat(), true);
                    options.appendProperty("correctFormat", "true", false);
                    break;
                }
                case "dropdown": {
                    this.encodeSelectItems(column, options);
                    break;
                }
                case "autocomplete": {
                    options.appendProperty("strict", column.isAutoCompleteStrict().toString(), false);
                    options.appendProperty("allowInvalid", column.isAutoCompleteAllowInvalid().toString(), false);
                    options.appendProperty("trimDropdown", column.isAutoCompleteTrimDropdown().toString(), false);
                    Integer visibleRows = column.getAutoCompleteVisibleRows();
                    if (visibleRows != null) {
                        options.appendProperty("visibleRows", visibleRows.toString(), false);
                    }
                    this.encodeSelectItems(column, options);
                    break;
                }
            }
            vb.appendArrayValue(options.closeVar().toString(), false);
        }
        wb.nativeAttr("columns", vb.closeVar().toString());
    }

    private void encodeSelectItems(SheetColumn column, JavascriptVarBuilder options) {
        JavascriptVarBuilder items = new JavascriptVarBuilder(null, false);
        Object value = column.getSelectItems();
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            for (int j = 0; j < Array.getLength(value); ++j) {
                Object item = Array.get(value, j);
                items.appendArrayValue(String.valueOf(item), true);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object item : collection) {
                items.appendArrayValue(String.valueOf(item), true);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Object item : map.keySet()) {
                items.appendArrayValue(String.valueOf(item), true);
            }
        }
        options.appendProperty("source", items.closeVar().toString(), false);
    }

    protected void encodeData(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        JavascriptVarBuilder jsData = new JavascriptVarBuilder(null, false);
        JavascriptVarBuilder jsRowKeys = new JavascriptVarBuilder(null, false);
        JavascriptVarBuilder jsStyle = new JavascriptVarBuilder(null, true);
        JavascriptVarBuilder jsRowStyle = new JavascriptVarBuilder(null, false);
        JavascriptVarBuilder jsReadOnly = new JavascriptVarBuilder(null, true);
        JavascriptVarBuilder jsRowHeaders = new JavascriptVarBuilder(null, false);
        boolean isCustomHeader = sheet.getRowHeaderValueExpression() != null;
        List<Object> values = sheet.getSortedValues();
        int row = 0;
        for (Object value : values) {
            context.getExternalContext().getRequestMap().put(sheet.getVar(), value);
            String rowKey = sheet.getRowKeyValueAsString(context);
            jsRowKeys.appendArrayValue(rowKey, true);
            this.encodeRow(context, rowKey, jsData, jsRowStyle, jsStyle, jsReadOnly, sheet, row);
            if (sheet.isShowRowHeaders().booleanValue() && isCustomHeader) {
                String rowHeader = sheet.getRowHeaderValueAsString(context);
                jsRowHeaders.appendArrayValue(rowHeader, true);
            }
            ++row;
        }
        sheet.setRowVar(context, null);
        wb.nativeAttr("data", jsData.closeVar().toString());
        wb.nativeAttr("styles", jsStyle.closeVar().toString());
        wb.nativeAttr("rowStyles", jsRowStyle.closeVar().toString());
        wb.nativeAttr("readOnlyCells", jsReadOnly.closeVar().toString());
        wb.nativeAttr("rowKeys", jsRowKeys.closeVar().toString());
        if (!isCustomHeader) {
            wb.nativeAttr("rowHeaders", sheet.isShowRowHeaders().toString());
        } else {
            wb.nativeAttr("rowHeaders", jsRowHeaders.closeVar().toString());
        }
    }

    protected JavascriptVarBuilder encodeRow(FacesContext context, String rowKey, JavascriptVarBuilder jsData, JavascriptVarBuilder jsRowStyle, JavascriptVarBuilder jsStyle, JavascriptVarBuilder jsReadOnly, Sheet sheet, int rowIndex) throws IOException {
        String rowStyleClass = sheet.getRowStyleClass();
        if (rowStyleClass == null) {
            jsRowStyle.appendArrayValue("null", false);
        } else {
            jsRowStyle.appendArrayValue(rowStyleClass, true);
        }
        JavascriptVarBuilder jsRow = new JavascriptVarBuilder(null, false);
        int renderCol = 0;
        for (int col = 0; col < sheet.getColumns().size(); ++col) {
            boolean readOnly;
            SheetColumn column = sheet.getColumns().get(col);
            if (!column.isRendered()) continue;
            String value = sheet.getRenderValueForCell(context, rowKey, col);
            jsRow.appendArrayValue(value, true);
            String styleClass = column.getStyleClass();
            if (styleClass != null) {
                jsStyle.appendRowColProperty(rowIndex, renderCol, styleClass, true);
            }
            if (readOnly = column.isReadonlyCell().booleanValue()) {
                jsReadOnly.appendRowColProperty(rowIndex, renderCol, "true", true);
            }
            ++renderCol;
        }
        jsData.appendArrayValue(jsRow.closeVar().toString(), false);
        return jsData;
    }

    private void encodeHiddenInputs(ResponseWriter responseWriter, Sheet sheet, String clientId) throws IOException {
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("id", (Object)(clientId + "_input"), "id");
        responseWriter.writeAttribute("name", (Object)(clientId + "_input"), "name");
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)"", null);
        responseWriter.endElement("input");
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("id", (Object)(clientId + "_focus"), "id");
        responseWriter.writeAttribute("name", (Object)(clientId + "_focus"), "name");
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        if (sheet.getFocusId() == null) {
            responseWriter.writeAttribute("value", (Object)"", null);
        } else {
            responseWriter.writeAttribute("value", (Object)sheet.getFocusId(), null);
        }
        responseWriter.endElement("input");
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("id", (Object)(clientId + "_selection"), "id");
        responseWriter.writeAttribute("name", (Object)(clientId + "_selection"), "name");
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        if (sheet.getSelection() == null) {
            responseWriter.writeAttribute("value", (Object)"", null);
        } else {
            responseWriter.writeAttribute("value", (Object)sheet.getSelection(), null);
        }
        responseWriter.endElement("input");
        int sortCol = sheet.getSortColRenderIndex();
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("id", (Object)(clientId + "_sortby"), "id");
        responseWriter.writeAttribute("name", (Object)(clientId + "_sortby"), "name");
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)sortCol, null);
        responseWriter.endElement("input");
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("id", (Object)(clientId + "_sortorder"), "id");
        responseWriter.writeAttribute("name", (Object)(clientId + "_sortorder"), "name");
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)sheet.getSortOrder().toLowerCase(), null);
        responseWriter.endElement("input");
    }

    private void encodeBehaviors(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        ClientBehaviorContext behaviorContext;
        Map behaviors = sheet.getClientBehaviors();
        wb.append(",behaviors:{");
        String clientId = sheet.getClientId();
        wb.append("sort").append(":").append("function(s, event)").append("{").append("PrimeFaces.ab({source: '").append(clientId).append("',event: 'sort', process: '").append(clientId).append("', update: '").append(clientId).append("'}, arguments[1]);}");
        wb.callback("filter", "function(s, event)", "PrimeFaces.ab({source: '" + clientId + "', event: 'filter', process: '" + clientId + "', update: '" + clientId + "'}, arguments[1]);");
        if (behaviors.containsKey("change")) {
            behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)sheet, (String)"change", (String)sheet.getClientId(context), null);
            wb.callback("change", "function(source, event)", ((ClientBehavior)((List)behaviors.get("change")).get(0)).getScript(behaviorContext));
        }
        if (behaviors.containsKey("cellSelect")) {
            behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)sheet, (String)"cellSelect", (String)sheet.getClientId(context), null);
            wb.callback("cellSelect", "function(source, event)", ((ClientBehavior)((List)behaviors.get("cellSelect")).get(0)).getScript(behaviorContext));
        }
        if (behaviors.containsKey("columnSelect")) {
            behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)sheet, (String)"columnSelect", (String)sheet.getClientId(context), null);
            wb.callback("columnSelect", "function(source, event)", ((ClientBehavior)((List)behaviors.get("columnSelect")).get(0)).getScript(behaviorContext));
        }
        if (behaviors.containsKey("rowSelect")) {
            behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)sheet, (String)"rowSelect", (String)sheet.getClientId(context), null);
            wb.callback("rowSelect", "function(source, event)", ((ClientBehavior)((List)behaviors.get("rowSelect")).get(0)).getScript(behaviorContext));
        }
        wb.append("}");
    }

    private void encodeFooter(FacesContext context, ResponseWriter responseWriter, Sheet sheet) throws IOException {
        UIComponent footer = sheet.getFacet("footer");
        if (footer != null) {
            responseWriter.startElement("div", null);
            responseWriter.writeAttribute("class", (Object)"ui-datatable-footer ui-widget-header ui-corner-bottom", null);
            footer.encodeAll(context);
            responseWriter.endElement("div");
        }
    }

    private void encodeHeader(FacesContext context, ResponseWriter responseWriter, Sheet sheet) throws IOException {
        UIComponent header = sheet.getFacet("header");
        if (header != null) {
            responseWriter.startElement("div", null);
            responseWriter.writeAttribute("class", (Object)"ui-datatable-header ui-widget-header ui-corner-top", null);
            header.encodeAll(context);
            responseWriter.endElement("div");
        }
    }

    protected void encodeFilterValues(FacesContext context, ResponseWriter responseWriter, Sheet sheet, String clientId) throws IOException {
        int renderIdx = 0;
        for (SheetColumn column : sheet.getColumns()) {
            if (!column.isRendered()) continue;
            if (column.getValueExpression("filterBy") != null) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("id", (Object)(clientId + "_filter_" + renderIdx), "id");
                responseWriter.writeAttribute("name", (Object)(clientId + "_filter_" + renderIdx), "name");
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("value", (Object)column.getFilterValue(), null);
                responseWriter.endElement("input");
            }
            ++renderIdx;
        }
    }

    protected void encodeFilterVar(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, false);
        for (SheetColumn column : sheet.getColumns()) {
            if (!column.isRendered()) continue;
            if (column.getValueExpression("filterBy") == null) {
                vb.appendArrayValue("false", true);
                continue;
            }
            Collection<SelectItem> options = column.getFilterOptions();
            if (options == null) {
                vb.appendArrayValue("true", true);
                continue;
            }
            JavascriptVarBuilder vbOptions = new JavascriptVarBuilder(null, false);
            for (SelectItem item : options) {
                vbOptions.appendArrayValue("{ label: \"" + item.getLabel() + "\", value: \"" + item.getValue() + "\"}", false);
            }
            vb.appendArrayValue(vbOptions.closeVar().toString(), false);
        }
        wb.nativeAttr("filters", vb.closeVar().toString());
    }

    protected void encodeSortVar(FacesContext context, Sheet sheet, WidgetBuilder wb) throws IOException {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, false);
        for (SheetColumn column : sheet.getColumns()) {
            if (!column.isRendered()) continue;
            if (column.getValueExpression("sortBy") == null) {
                vb.appendArrayValue("false", false);
                continue;
            }
            vb.appendArrayValue("true", false);
        }
        wb.nativeAttr("sortable", vb.closeVar().toString());
    }

    public void decode(FacesContext context, UIComponent component) {
        int col;
        Sheet sheet = (Sheet)component;
        for (SheetColumn column : sheet.getColumns()) {
            column.setSheet(sheet);
        }
        sheet.getUpdates().clear();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = sheet.getClientId(context);
        String jsonUpdates = (String)params.get(clientId + "_input");
        String jsonSelection = (String)params.get(clientId + "_selection");
        this.decodeSubmittedValues(context, sheet, jsonUpdates);
        this.decodeSelection(context, sheet, jsonSelection);
        this.decodeBehaviors(context, (UIComponent)sheet);
        this.decodeFilters(context, sheet, params, clientId);
        String sortBy = (String)params.get(clientId + "_sortby");
        String sortOrder = (String)params.get(clientId + "_sortorder");
        if (sortBy != null && (col = Integer.valueOf(sortBy).intValue()) >= 0) {
            col = sheet.getMappedColumn(col);
            sheet.setSortByValueExpression(sheet.getColumns().get(col).getValueExpression("sortBy"));
        }
        if (sortOrder != null) {
            sheet.setSortOrder(sortOrder);
        }
        String focus = (String)params.get(clientId + "_focus");
        sheet.setFocusId(focus);
    }

    protected void decodeFilters(FacesContext context, Sheet sheet, Map<String, String> params, String clientId) {
        int renderIdx = 0;
        for (SheetColumn column : sheet.getColumns()) {
            if (!column.isRendered()) continue;
            if (column.getValueExpression("filterBy") != null) {
                String value = params.get(clientId + "_filter_" + renderIdx);
                column.setFilterValue(value);
            }
            ++renderIdx;
        }
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent == null) {
            return;
        }
        List behaviorsForEvent = (List)behaviors.get(behaviorEvent);
        if (behaviorsForEvent == null || behaviorsForEvent.isEmpty()) {
            return;
        }
        String behaviorSource = (String)params.get("javax.faces.source");
        String clientId = component.getClientId();
        if (behaviorSource != null && clientId.equals(behaviorSource)) {
            for (ClientBehavior behavior : behaviorsForEvent) {
                behavior.decode(context, component);
            }
        }
    }

    private void decodeSelection(FacesContext context, Sheet sheet, String jsonSelection) {
        if (StringUtils.isEmpty((CharSequence)jsonSelection)) {
            return;
        }
        try {
            JSONArray array = new JSONArray(jsonSelection);
            sheet.setSelectedRow(array.getInt(0));
            sheet.setSelectedColumn(sheet.getMappedColumn(array.getInt(1)));
            sheet.setSelectedLastRow(array.getInt(2));
            sheet.setSelectedLastColumn(array.getInt(3));
            sheet.setSelection(jsonSelection);
        }
        catch (JSONException e) {
            throw new FacesException("Failed parsing Ajax JSON message for cell selection event:" + e.getMessage(), (Throwable)e);
        }
    }

    private void decodeSubmittedValues(FacesContext context, Sheet sheet, String jsonData) {
        if (StringUtils.isEmpty((CharSequence)jsonData)) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(jsonData);
            Iterator keys = obj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray update = obj.getJSONArray(key);
                if (update.isNull(4)) continue;
                String rowKey = update.getString(4);
                int col = sheet.getMappedColumn(update.getInt(1));
                String newValue = String.valueOf(update.get(3));
                sheet.setSubmittedValue(context, rowKey, col, newValue);
            }
        }
        catch (JSONException ex) {
            throw new FacesException("Failed parsing Ajax JSON message for cell change event:" + ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

