/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.blockui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.blockui.BlockUI;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class BlockUIRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        this.encodeMarkup(fc, component);
        this.encodeScript(fc, component);
    }

    protected void encodeMarkup(FacesContext fc, UIComponent component) throws IOException {
        BlockUI blockUI = (BlockUI)component;
        if (blockUI.getContent() == null && blockUI.getChildCount() > 0) {
            ResponseWriter writer = fc.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(blockUI.getClientId(fc) + "_content"), null);
            writer.writeAttribute("style", (Object)"display: none;", null);
            this.renderChildren(fc, component);
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext fc, UIComponent component) throws IOException {
        int timeout;
        String cssOverlay;
        String eventRegEx;
        BlockUI blockUI = (BlockUI)component;
        String clientId = blockUI.getClientId(fc);
        String source = blockUI.getSource();
        source = source == null ? blockUI.getParent().getClientId(fc) : SearchExpressionFacade.resolveClientIds((FacesContext)fc, (UIComponent)blockUI, (String)source);
        if (source == null) {
            throw new FacesException("Cannot find source for blockUI component '" + clientId + "'.");
        }
        String target = blockUI.getTarget();
        if (target != null) {
            target = SearchExpressionFacade.resolveClientIds((FacesContext)fc, (UIComponent)blockUI, (String)target);
        }
        String jqContent = null;
        boolean isContentExtern = false;
        if (blockUI.getContent() != null) {
            UIComponent contentComponent = blockUI.findComponent(blockUI.getContent());
            if (contentComponent == null) {
                throw new FacesException("Cannot find content for blockUI component '" + clientId + "'.");
            }
            jqContent = "#" + contentComponent.getClientId(fc);
            isContentExtern = true;
        } else if (blockUI.getChildCount() > 0) {
            jqContent = "#" + clientId + "_content";
        }
        String events = blockUI.getEvent();
        if (StringUtils.isBlank((CharSequence)events)) {
            eventRegEx = "/javax.faces.source=" + source + "(.)*$/";
        } else {
            String[] arrEvents = events.split("[\\s,]+");
            StringBuilder sb = new StringBuilder("/");
            for (int i = 0; i < arrEvents.length; ++i) {
                sb.append("javax.faces.behavior.event");
                sb.append("=");
                sb.append(arrEvents[i]);
                if (i + 1 >= arrEvents.length) continue;
                sb.append("|");
            }
            sb.append("/");
            eventRegEx = sb.toString();
        }
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.initWithDomReady("ExtBlockUI", blockUI.resolveWidgetVar(), clientId);
        wb.attr("source", source);
        if (target != null) {
            wb.attr("target", target);
        }
        wb.attr("autoShow", Boolean.valueOf(blockUI.isAutoShow()));
        String css = blockUI.getCss();
        if (css != null) {
            wb.attr("css", css);
        }
        if ((cssOverlay = blockUI.getCssOverlay()) != null) {
            wb.nativeAttr("overlayCSS", cssOverlay);
        }
        if ((timeout = blockUI.getTimeout()) > 0) {
            wb.attr("timeout", (Number)timeout);
        }
        wb.attr("centerX", Boolean.valueOf(blockUI.isCenterX()));
        wb.attr("centerY", Boolean.valueOf(blockUI.isCenterY()));
        if (jqContent != null) {
            wb.selectorAttr("content", jqContent);
        }
        wb.attr("contentExtern", Boolean.valueOf(isContentExtern));
        wb.attr("namingContSep", Character.toString(UINamingContainer.getSeparatorChar((FacesContext)fc)));
        wb.nativeAttr("regEx", eventRegEx);
        wb.finish();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) throws IOException {
    }
}

