/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.clipboard;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.clipboard.Clipboard;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ClipboardRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Clipboard clipboard = (Clipboard)component;
        this.encodeScript(context, clipboard);
    }

    private void encodeScript(FacesContext context, Clipboard clipboard) throws IOException {
        String trigger = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)clipboard, (String)clipboard.getTrigger());
        if (this.isValueBlank(trigger)) {
            trigger = clipboard.getParent().getClientId(context);
        }
        String target = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)clipboard, (String)clipboard.getTarget());
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("ExtClipboard", clipboard.resolveWidgetVar(), clipboard.getClientId(context));
        wb.attr("action", StringUtils.lowerCase((String)clipboard.getAction()));
        wb.attr("trigger", trigger);
        wb.attr("target", target);
        wb.attr("text", clipboard.getText());
        if (clipboard.getOnsuccess() != null) {
            wb.callback("onSuccess", "function(e)", clipboard.getOnsuccess());
        }
        if (clipboard.getOnerror() != null) {
            wb.callback("onError", "function(e)", clipboard.getOnerror());
        }
        this.encodeClientBehaviors(context, clipboard);
        wb.finish();
    }
}

