/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.parameters;

import java.io.IOException;
import java.util.Arrays;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class MethodSignatureTagHandler
extends TagHandler {
    public static final String PARAMETERS_TYPES_ATTRIBUTE_NAME = "METHOD_SIGNATURE_PARAMETER_TYPES";
    private final Class<?>[] parameterTypes;

    public MethodSignatureTagHandler(TagConfig config) {
        super(config);
        TagAttribute parametersTag = this.getRequiredAttribute("parameters");
        try {
            this.parameterTypes = this.parseParameterTypes(parametersTag.getValue());
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        parent.getAttributes().put(PARAMETERS_TYPES_ATTRIBUTE_NAME, this.parameterTypes);
    }

    public Class<?>[] getParameterTypes() {
        if (this.parameterTypes != null) {
            return Arrays.copyOf(this.parameterTypes, this.parameterTypes.length);
        }
        return null;
    }

    private Class<?>[] parseParameterTypes(String parameters) throws ClassNotFoundException {
        String[] splittedParameters = parameters.split(",");
        Class[] parameterTypes = new Class[splittedParameters.length];
        for (int i = 0; i < splittedParameters.length; ++i) {
            parameterTypes[i] = Class.forName(splittedParameters[i].trim());
        }
        return parameterTypes;
    }
}

