/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.extensions.component.sheet.SheetColumn;
import org.primefaces.extensions.component.sheet.SheetInvalidUpdate;
import org.primefaces.extensions.event.SheetUpdate;
import org.primefaces.extensions.util.JavascriptVarBuilder;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.SortOrder;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces-extensions", target="head", name="sheet/sheet.css"), @ResourceDependency(library="primefaces-extensions", name="sheet/sheet.js")})
public class Sheet
extends UIInput
implements ClientBehaviorHolder,
EditableValueHolder,
Widget {
    public static final String EVENT_CELL_SELECT = "cellSelect";
    public static final String EVENT_CHANGE = "change";
    public static final String EVENT_SORT = "sort";
    public static final String EVENT_FILTER = "filter";
    public static final String EVENT_COLUMN_SELECT = "columnSelect";
    public static final String EVENT_ROW_SELECT = "rowSelect";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Sheet";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.SheetRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("change", "cellSelect", "sort", "filter", "columnSelect", "rowSelect"));
    private List<SheetColumn> columns;
    private List<SheetInvalidUpdate> invalidUpdates;
    private List<Object> sortedList;
    private Map<RowColIndex, String> submittedValues = new HashMap<RowColIndex, String>();
    private Map<RowColIndex, Object> localValues = new HashMap<RowColIndex, Object>();
    private String selection;
    private String focusId;
    private final List<SheetUpdate> updates = new ArrayList<SheetUpdate>();
    private Map<Integer, Integer> columnMapping;
    private Map<String, Object> rowMap;

    public Sheet() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return EVENT_CHANGE;
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public String getStyleClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setStretchH(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stretchH), (Object)value);
    }

    public String getStretchH() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stretchH), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setEmptyMessage(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)value);
    }

    public String getEmptyMessage() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setCurrentColClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentColClass), (Object)styleClass);
    }

    public String getCurrentColClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentColClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setCurrentRowClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentRowClass), (Object)styleClass);
    }

    public String getCurrentRowClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentRowClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setRowStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)styleClass);
    }

    public String getRowStyleClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setShowColumnHeaders(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showColumnHeaders), (Object)value);
    }

    public Boolean isShowColumnHeaders() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showColumnHeaders), (Object)true).toString());
    }

    public void setShowRowHeaders(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showRowHeaders), (Object)value);
    }

    public Boolean isShowRowHeaders() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showRowHeaders), (Object)true).toString());
    }

    public List<SheetColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<SheetColumn>();
            this.getColumns((UIComponent)this);
        }
        return this.columns;
    }

    private void getColumns(UIComponent parent) {
        for (UIComponent child : parent.getChildren()) {
            if (!(child instanceof SheetColumn)) continue;
            this.columns.add((SheetColumn)child);
        }
    }

    public void setColumns(List<SheetColumn> columns) {
        this.columns = columns;
    }

    public void setFixedRows(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fixedRows), (Object)value);
    }

    public Integer getFixedRows() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedRows), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setFixedCols(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fixedCols), (Object)value);
    }

    public Integer getFixedCols() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedCols), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public List<SheetInvalidUpdate> getInvalidUpdates() {
        if (this.invalidUpdates == null) {
            this.invalidUpdates = new ArrayList<SheetInvalidUpdate>();
        }
        return this.invalidUpdates;
    }

    public void resetSubmitted() {
        this.submittedValues.clear();
    }

    public void resetSort() {
        ValueExpression origSortBy = (ValueExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.origSortBy));
        this.setSortByValueExpression(origSortBy);
        String origSortOrder = (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.origSortOrder));
        if (origSortOrder != null) {
            this.setSortOrder(origSortOrder);
        }
    }

    public void resetInvalidUpdates() {
        this.getInvalidUpdates().clear();
    }

    public void reset() {
        this.resetSubmitted();
        this.resetSort();
        this.resetInvalidUpdates();
        this.localValues.clear();
        for (SheetColumn c : this.getColumns()) {
            c.setFilterValue(null);
        }
    }

    public void setSubmittedValue(FacesContext context, String rowKey, int col, String value) {
        this.submittedValues.put(new RowColIndex(rowKey, col), value);
    }

    public String getSubmittedValue(String rowKey, int col) {
        return this.submittedValues.get(new RowColIndex(rowKey, col));
    }

    public void setLocalValue(String rowKey, int col, Object value) {
        this.localValues.put(new RowColIndex(rowKey, col), value);
    }

    public Object getLocalValue(String rowKey, int col) {
        return this.localValues.get(new RowColIndex(rowKey, col));
    }

    public void setRowVar(FacesContext context, String rowKey) {
        if (context == null) {
            return;
        }
        if (rowKey == null) {
            context.getExternalContext().getRequestMap().remove(this.getVar());
        } else {
            Object value = this.rowMap.get(rowKey);
            context.getExternalContext().getRequestMap().put(this.getVar(), value);
        }
    }

    public Object getValueForCell(FacesContext context, String rowKey, int col) {
        RowColIndex index = new RowColIndex(rowKey, col);
        if (this.localValues.containsKey(index)) {
            return this.localValues.get(index);
        }
        this.setRowVar(context, rowKey);
        SheetColumn column = this.getColumns().get(col);
        return column.getValueExpression("value").getValue(context.getELContext());
    }

    public String getRenderValueForCell(FacesContext context, String rowKey, int col) {
        RowColIndex index = new RowColIndex(rowKey, col);
        if (this.submittedValues.containsKey(index)) {
            return this.submittedValues.get(index);
        }
        Object value = this.getValueForCell(context, rowKey, col);
        if (value == null) {
            return null;
        }
        SheetColumn column = this.getColumns().get(col);
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)column);
        if (converter == null) {
            return value.toString();
        }
        return converter.getAsString(context, (UIComponent)this, value);
    }

    public Integer getSelectedColumn() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedColumn));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setSelectedColumn(Integer col) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedColumn), (Object)col);
    }

    public Integer getSelectedLastColumn() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedLastColumn));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setSelectedLastColumn(Integer col) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedLastColumn), (Object)col);
    }

    public Integer getSelectedRow() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedRow));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public Integer getSelectedLastRow() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectedLastRow));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setSelectedRow(Integer row) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedRow), (Object)row);
    }

    public void setSelectedLastRow(Integer row) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectedLastRow), (Object)row);
    }

    public Integer getWidth() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setWidth(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), (Object)value);
    }

    public Integer getHeight() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height));
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setHeight(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)value);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public List<Object> getSortedValues() {
        if (this.sortedList == null) {
            this.sortAndFilter();
        }
        return this.sortedList;
    }

    public int getSortColRenderIndex() {
        ValueExpression veSortBy = this.getValueExpression(PropertyKeys.sortBy.name());
        if (veSortBy == null) {
            return -1;
        }
        String sortByExp = veSortBy.getExpressionString();
        int colIdx = 0;
        for (SheetColumn column : this.getColumns()) {
            if (!column.isRendered()) continue;
            ValueExpression veCol = column.getValueExpression(PropertyKeys.sortBy.name());
            if (veCol != null && veCol.getExpressionString().equals(sortByExp)) {
                return colIdx;
            }
            ++colIdx;
        }
        return -1;
    }

    protected boolean matchesFilter(Object obj) {
        for (SheetColumn col : this.getColumns()) {
            String compareB;
            String filterValue = col.getFilterValue();
            if (StringUtils.isEmpty((CharSequence)filterValue)) continue;
            Object filterBy = col.getFilterBy();
            if (filterBy == null) {
                return false;
            }
            String compareA = filterBy.toString().toLowerCase();
            if (compareA.contains(compareB = filterValue.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortAndFilter() {
        this.sortedList = new ArrayList<Object>();
        this.rowMap = new HashMap<String, Object>();
        Collection values = (Collection)this.getValue();
        if (values == null || values.isEmpty()) {
            return;
        }
        this.reMapRows();
        boolean filters = false;
        for (SheetColumn col : this.getColumns()) {
            if (!StringUtils.isNotEmpty((CharSequence)col.getFilterValue())) continue;
            filters = true;
            break;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        if (filters) {
            String var = this.getVar();
            for (Object obj : values) {
                requestMap.put(var, obj);
                try {
                    if (!this.matchesFilter(obj)) continue;
                    this.sortedList.add(obj);
                }
                finally {
                    requestMap.remove(var);
                }
            }
        } else {
            this.sortedList.addAll(values);
        }
        ValueExpression veSortBy = this.getValueExpression(PropertyKeys.sortBy.name());
        if (veSortBy != null) {
            Collections.sort(this.sortedList, new BeanPropertyComparator(veSortBy, this.getVar(), this.convertSortOrder(), null, false, Locale.ENGLISH, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reMapRows() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        Collection values = (Collection)this.getValue();
        String var = this.getVar();
        for (Object obj : values) {
            requestMap.put(var, obj);
            try {
                this.rowMap.put(this.getRowKeyValueAsString(context), obj);
            }
            finally {
                requestMap.remove(var);
            }
        }
    }

    protected Object getRowKeyValue(FacesContext context) {
        ValueExpression veRowKey = this.getValueExpression(PropertyKeys.rowKey.name());
        if (veRowKey == null) {
            throw new RuntimeException("RowKey required on sheet!");
        }
        Object value = veRowKey.getValue(context.getELContext());
        if (value == null) {
            throw new RuntimeException("RowKey must resolve to non-null value for updates to work properly");
        }
        return value;
    }

    protected String getRowKeyValueAsString(Object key) {
        String result = key.toString();
        return "r_" + StringUtils.deleteWhitespace((String)result);
    }

    protected String getRowKeyValueAsString(FacesContext context) {
        return this.getRowKeyValueAsString(this.getRowKeyValue(context));
    }

    protected SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        SortOrder result = SortOrder.valueOf((String)sortOrder.toUpperCase(Locale.ENGLISH));
        return result;
    }

    public void setValue(Object value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)var);
    }

    public ValueExpression getSortByValueExpression() {
        ValueExpression veSortBy = this.getValueExpression(PropertyKeys.sortBy.name());
        return veSortBy;
    }

    public void setSortByValueExpression(ValueExpression sortBy) {
        this.setValueExpression(PropertyKeys.sortBy.name(), sortBy);
    }

    public String getSortOrder() {
        String result = (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)SortOrder.ASCENDING.toString());
        return result;
    }

    public void setSortOrder(String sortOrder) {
        String orig = (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.origSortOrder));
        if (orig == null) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.origSortOrder), this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder)));
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)sortOrder);
    }

    public String getErrorMessage() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.errorMessage));
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setErrorMessage(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.errorMessage), (Object)value);
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(FacesContext context) {
        Iterator<Map.Entry<RowColIndex, String>> entries = this.submittedValues.entrySet().iterator();
        boolean hadBadUpdates = !this.getInvalidUpdates().isEmpty();
        this.getInvalidUpdates().clear();
        while (entries.hasNext()) {
            Map.Entry<RowColIndex, String> entry = entries.next();
            SheetColumn column = this.getColumns().get(entry.getKey().colIndex);
            String newValue = entry.getValue();
            String rowKey = entry.getKey().getRowKey();
            int col = entry.getKey().getColIndex();
            this.setRowVar(context, rowKey);
            Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)column);
            Object newValueObj = newValue;
            if (converter != null) {
                try {
                    newValueObj = converter.getAsObject(context, (UIComponent)this, newValue);
                }
                catch (ConverterException e) {
                    this.setValid(false);
                    FacesMessage message = e.getFacesMessage();
                    if (message == null) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), e.getMessage());
                    }
                    context.addMessage(this.getClientId(context), message);
                    String messageText = message.getDetail();
                    this.getInvalidUpdates().add(new SheetInvalidUpdate(this.getRowKeyValue(context), col, column, newValue, messageText));
                    continue;
                }
            }
            this.setLocalValue(rowKey, col, newValueObj);
            column.setValue(newValueObj);
            try {
                column.validate(context);
            }
            finally {
                column.resetValue();
            }
            entries.remove();
        }
        this.setRowVar(context, null);
        boolean newBadUpdates = !this.getInvalidUpdates().isEmpty();
        String errorMessage = this.getErrorMessage();
        if ((hadBadUpdates || newBadUpdates) && context.getPartialViewContext().isPartialRequest()) {
            this.renderBadUpdateScript(context);
        }
        if (newBadUpdates && errorMessage != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage);
            context.addMessage(null, message);
        }
    }

    public void updateModel(FacesContext context) {
        Iterator<Map.Entry<RowColIndex, Object>> entries = this.localValues.entrySet().iterator();
        HashSet<String> dirtyRows = new HashSet<String>();
        while (entries.hasNext()) {
            Map.Entry<RowColIndex, Object> entry = entries.next();
            Object newValue = entry.getValue();
            String rowKey = entry.getKey().getRowKey();
            int col = entry.getKey().getColIndex();
            SheetColumn column = this.getColumns().get(col);
            this.setRowVar(context, rowKey);
            Object rowVal = this.rowMap.get(rowKey);
            ValueExpression ve = column.getValueExpression(PropertyKeys.value.name());
            ELContext elContext = context.getELContext();
            Object oldValue = ve.getValue(elContext);
            ve.setValue(elContext, newValue);
            entries.remove();
            this.appendUpdateEvent(this.getRowKeyValue(context), col, rowVal, oldValue, newValue);
            dirtyRows.add(rowKey);
        }
        this.setLocalValueSet(false);
        this.setRowVar(context, null);
        if (context.getPartialViewContext().isPartialRequest()) {
            this.renderRowUpdateScript(context, dirtyRows);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.submittedValues, this.localValues, this.invalidUpdates, this.columnMapping, this.sortedList, this.rowMap};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        Object restoredSubmittedValues = values[1];
        Object restoredLocalValues = values[2];
        Object restoredInvalidUpdates = values[3];
        Object restoredColMappings = values[4];
        Object restoredSortedList = values[5];
        Object restoredRowMap = values[6];
        if (restoredSubmittedValues == null) {
            this.submittedValues.clear();
        } else {
            this.submittedValues = (Map)restoredSubmittedValues;
        }
        if (restoredLocalValues == null) {
            this.localValues.clear();
        } else {
            this.localValues = (Map)restoredLocalValues;
        }
        if (restoredInvalidUpdates == null) {
            this.getInvalidUpdates().clear();
        } else {
            this.invalidUpdates = (List)restoredInvalidUpdates;
        }
        this.columnMapping = restoredColMappings == null ? null : (Map)restoredColMappings;
        this.sortedList = restoredSortedList == null ? null : (List)restoredSortedList;
        this.rowMap = restoredRowMap == null ? null : (Map)restoredRowMap;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public Object getSubmittedValue() {
        if (this.submittedValues.isEmpty()) {
            return null;
        }
        return this.submittedValues;
    }

    public void setSubmittedValue(Object submittedValue) {
        if (submittedValue == null) {
            this.submittedValues.clear();
        } else {
            this.submittedValues = (Map)submittedValue;
        }
    }

    public List<SheetUpdate> getUpdates() {
        return this.updates;
    }

    protected void appendUpdateEvent(Object rowKey, int colIndex, Object rowData, Object oldValue, Object newValue) {
        this.updates.add(new SheetUpdate(rowKey, colIndex, rowData, oldValue, newValue));
    }

    public boolean isHasStyledCells() {
        for (SheetColumn column : this.getColumns()) {
            if (column.getStyleClass() == null) continue;
            return true;
        }
        return false;
    }

    public int getMappedColumn(int renderIdx) {
        if (this.columnMapping == null || renderIdx == -1) {
            return renderIdx;
        }
        Integer result = this.columnMapping.get(renderIdx);
        if (result == null) {
            throw new IllegalArgumentException("Invalid index " + renderIdx);
        }
        return result;
    }

    public int getRenderIndexFromRealIdx(int realIdx) {
        if (this.columnMapping == null || realIdx == -1) {
            return realIdx;
        }
        for (Map.Entry<Integer, Integer> entry : this.columnMapping.entrySet()) {
            if (!entry.getValue().equals(realIdx)) continue;
            return entry.getKey();
        }
        return realIdx;
    }

    public void updateColumnMappings() {
        this.columnMapping = new HashMap<Integer, Integer>();
        int realIdx = 0;
        int renderIdx = 0;
        for (SheetColumn column : this.getColumns()) {
            if (column.isRendered()) {
                this.columnMapping.put(renderIdx, realIdx);
                ++renderIdx;
            }
            ++realIdx;
        }
    }

    public int getRowCount() {
        List<Object> values = this.getSortedValues();
        if (values == null) {
            return 0;
        }
        return values.size();
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public void commitUpdates() {
        this.resetSubmitted();
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext().isPartialRequest()) {
            StringBuilder eval = new StringBuilder();
            String jQueryId = this.getClientId().replace(":", "\\\\:");
            String jsDeltaVar = this.getClientId().replace(":", "_") + "_delta";
            eval.append("$('#");
            eval.append(jQueryId);
            eval.append("_input').val('');");
            eval.append(jsDeltaVar);
            eval.append("={};");
            RequestContext.getCurrentInstance().getScriptsToExecute().add(eval.toString());
        }
    }

    public String getInvalidDataValue() {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, true);
        for (SheetInvalidUpdate sheetInvalidUpdate : this.getInvalidUpdates()) {
            Object rowKey = sheetInvalidUpdate.getInvalidRowKey();
            int col = this.getRenderIndexFromRealIdx(sheetInvalidUpdate.getInvalidColIndex());
            String rowKeyProperty = this.getRowKeyValueAsString(rowKey);
            vb.appendProperty(rowKeyProperty + "_c" + col, sheetInvalidUpdate.getInvalidMessage().replace("'", "&apos;"), true);
        }
        return vb.closeVar().toString();
    }

    protected void renderRowUpdateScript(FacesContext context, Set<String> dirtyRows) {
        String jsVar = this.resolveWidgetVar();
        StringBuilder eval = new StringBuilder();
        for (String rowKey : dirtyRows) {
            this.setRowVar(context, rowKey);
            JavascriptVarBuilder vbRow = new JavascriptVarBuilder(null, false);
            for (int col = 0; col < this.getColumns().size(); ++col) {
                SheetColumn column = this.getColumns().get(col);
                if (!column.isRendered()) continue;
                String value = this.getRenderValueForCell(context, rowKey, col);
                vbRow.appendArrayValue(value, true);
            }
            eval.append("PF('" + jsVar + "')");
            eval.append(".updateData('");
            eval.append(rowKey);
            eval.append("',");
            eval.append(vbRow.closeVar().toString());
            eval.append(");");
        }
        eval.append("PF('" + jsVar + "')");
        eval.append(".ht.render();");
        RequestContext.getCurrentInstance().getScriptsToExecute().add(eval.toString());
    }

    protected void renderBadUpdateScript(FacesContext context) {
        String widgetVar = this.resolveWidgetVar();
        String invalidValue = this.getInvalidDataValue();
        StringBuilder sb = new StringBuilder("PF('" + widgetVar + "')");
        sb.append(".cfg.errors=");
        sb.append(invalidValue);
        sb.append(";");
        sb.append("PF('" + widgetVar + "')");
        sb.append(".ht.render();");
        RequestContext.getCurrentInstance().getScriptsToExecute().add(sb.toString());
        sb = new StringBuilder();
        sb.append("PF('" + widgetVar + "')");
        sb.append(".sheetDiv.removeClass('ui-state-error')");
        if (!this.getInvalidUpdates().isEmpty()) {
            sb.append(".addClass('ui-state-error')");
        }
        RequestContext.getCurrentInstance().getScriptsToExecute().add(sb.toString());
    }

    private class RowColIndex
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String rowKey;
        private final Integer colIndex;

        public RowColIndex(String rowKey, Integer col) {
            this.rowKey = rowKey;
            this.colIndex = col;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RowColIndex)) {
                return false;
            }
            RowColIndex castOther = (RowColIndex)other;
            return new EqualsBuilder().append((Object)this.rowKey, (Object)castOther.rowKey).append((Object)this.colIndex, (Object)castOther.colIndex).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.rowKey).append((Object)this.colIndex).toHashCode();
        }

        public String getRowKey() {
            return this.rowKey;
        }

        public Integer getColIndex() {
            return this.colIndex;
        }
    }

    static enum PropertyKeys {
        value,
        valid,
        var,
        selectedRow,
        selectedLastRow,
        selectedColumn,
        selectedLastColumn,
        showColumnHeaders,
        showRowHeaders,
        fixedRows,
        fixedCols,
        width,
        height,
        errorMessage,
        styleClass,
        currentRowClass,
        currentColClass,
        rowKey,
        sortBy,
        sortOrder,
        origSortBy,
        origSortOrder,
        stretchH,
        rowStyleClass,
        emptyMessage;

    }
}

