/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.speedtest;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.speedtest.Speedtest;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.WidgetBuilder;

public class SpeedtestRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Speedtest speedtest = (Speedtest)component;
        this.encodeMarkup(context, speedtest);
        this.encodeScript(context, speedtest);
    }

    private void encodeMarkup(FacesContext context, Speedtest speedtest) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = speedtest.getClientId(context);
        String widgetVar = speedtest.resolveWidgetVar();
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("id", (Object)(clientId + "SpeedTest"), "id");
        if (speedtest.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)speedtest.getStyleClass(), "styleClass");
        }
        if (speedtest.getStyle() != null) {
            writer.writeAttribute("style", (Object)speedtest.getStyle(), "style");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g", null);
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("id", (Object)(clientId + "ggdown"), "id");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("id", (Object)(clientId + "ggup"), "id");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("id", (Object)(clientId + "ggping"), "id");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("id", (Object)(clientId + "ggjitter"), "id");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Speedtest speedtest) throws IOException {
        String clientId = speedtest.getClientId(context);
        UIForm form = ComponentTraversalUtils.closestForm((FacesContext)context, (UIComponent)speedtest);
        if (form == null) {
            throw new FacesException("Speedtest:" + clientId + " needs to be enclosed in a form component");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("ExtSpeedtest", speedtest.resolveWidgetVar(), clientId);
        wb.attr("IdDown", clientId + "ggdown");
        wb.attr("IdUp", clientId + "ggup");
        wb.attr("IdPing", clientId + "ggping");
        wb.attr("IdJitter", clientId + "ggjitter");
        wb.attr("CaptionPing", speedtest.getCaptionPing());
        wb.attr("CaptionJitter", speedtest.getCaptionJitter());
        wb.attr("CaptionDownload", speedtest.getCaptionDownload());
        wb.attr("CaptionUpload", speedtest.getCaptionUpload());
        wb.attr("ColorPing", speedtest.getColorPing());
        wb.attr("ColorJitter", speedtest.getColorJitter());
        wb.attr("ColorDownload", speedtest.getColorDownload());
        wb.attr("ColorUpload", speedtest.getColorUpload());
        wb.attr("File", speedtest.getFile());
        this.encodeClientBehaviors(context, speedtest);
        wb.finish();
    }
}

