/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import org.primefaces.util.ComponentUtils;

public class JavascriptVarBuilder {
    private final StringBuilder sb = new StringBuilder();
    private final boolean isObject;
    private boolean firstValue = true;
    private final boolean isVar;

    public JavascriptVarBuilder(String varName, boolean isObject) {
        this.isObject = isObject;
        boolean bl = this.isVar = varName != null;
        if (this.isVar) {
            this.sb.append("var ");
            this.sb.append(varName);
            this.sb.append("=");
        }
        if (isObject) {
            this.sb.append("{");
        } else {
            this.sb.append("[");
        }
    }

    private void next() {
        if (this.firstValue) {
            this.firstValue = false;
        } else {
            this.sb.append(",");
        }
    }

    public JavascriptVarBuilder appendProperty(String propertyName, String propertyValue, boolean quoted) {
        this.next();
        this.sb.append(propertyName);
        this.sb.append(":");
        this.appendText(propertyValue, quoted);
        return this;
    }

    public JavascriptVarBuilder appendRowColProperty(int row, int col, String propertyValue, boolean quoted) {
        return this.appendProperty("r" + row + "_c" + col, propertyValue, quoted);
    }

    public JavascriptVarBuilder appendText(String value, boolean quoted) {
        if (quoted) {
            this.sb.append("\"");
            if (value != null) {
                this.sb.append(ComponentUtils.escapeEcmaScriptText((String)value));
            }
            this.sb.append("\"");
        } else if (value != null) {
            this.sb.append(value);
        }
        return this;
    }

    public JavascriptVarBuilder appendArrayValue(String value, boolean quoted) {
        this.next();
        return this.appendText(value, quoted);
    }

    public JavascriptVarBuilder closeVar() {
        if (this.isObject) {
            this.sb.append("}");
        } else {
            this.sb.append("]");
        }
        if (this.isVar) {
            this.sb.append(";");
        }
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }
}

