/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.masterdetail;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.primefaces.component.breadcrumb.BreadCrumb;
import org.primefaces.extensions.component.masterdetail.MasterDetail;
import org.primefaces.extensions.component.masterdetail.MasterDetailLevel;
import org.primefaces.extensions.component.masterdetail.MasterDetailLevelVisitCallback;
import org.primefaces.extensions.component.masterdetail.SelectLevelEvent;
import org.primefaces.model.menu.DefaultMenuItem;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;

public class MasterDetailRenderer
extends CoreRenderer {
    private static final String FACET_HEADER = "header";
    private static final String FACET_FOOTER = "footer";
    private static final String FACET_LABEL = "label";

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        MasterDetailLevel mdl;
        MasterDetail masterDetail = (MasterDetail)component;
        if (masterDetail.isSelectDetailRequest(fc)) {
            MasterDetailLevel mdlToProcess = masterDetail.getDetailLevelToProcess(fc);
            if (fc.isValidationFailed()) {
                mdl = mdlToProcess;
            } else {
                mdl = this.getDetailLevelToEncode(fc, masterDetail, mdlToProcess, masterDetail.getDetailLevelToGo(fc));
                MasterDetailLevelVisitCallback visitCallback = new MasterDetailLevelVisitCallback();
                mdlToProcess.visitTree(VisitContext.createVisitContext((FacesContext)fc), visitCallback);
                String preserveInputs = masterDetail.getPreserveInputs(fc);
                String resetInputs = masterDetail.getResetInputs(fc);
                Object[] piIds = preserveInputs != null ? preserveInputs.split("[\\s,]+") : null;
                Object[] riIds = resetInputs != null ? resetInputs.split("[\\s,]+") : null;
                boolean preserveAll = ArrayUtils.contains((Object[])piIds, (Object)"@all");
                boolean resetAll = ArrayUtils.contains((Object[])riIds, (Object)"@all");
                List<EditableValueHolder> editableValueHolders = visitCallback.getEditableValueHolders();
                for (EditableValueHolder editableValueHolder : editableValueHolders) {
                    String clientId = ((UIComponent)editableValueHolder).getClientId(fc);
                    if (resetAll || ArrayUtils.contains((Object[])riIds, (Object)clientId)) {
                        editableValueHolder.resetValue();
                        continue;
                    }
                    if (preserveAll || ArrayUtils.contains((Object[])piIds, (Object)clientId)) {
                        editableValueHolder.setValue(MasterDetailRenderer.getConvertedSubmittedValue(fc, editableValueHolder));
                        continue;
                    }
                    editableValueHolder.resetValue();
                }
            }
            masterDetail.updateModel(fc, mdl);
        } else {
            mdl = masterDetail.getDetailLevelByLevel(masterDetail.getLevel());
        }
        if (mdl == null) {
            throw new FacesException("MasterDetailLevel [Level=" + String.valueOf(masterDetail.getLevel()) + "] must be nested inside a MasterDetail component!");
        }
        this.encodeMarkup(fc, masterDetail, mdl);
        masterDetail.resetCalculatedValues();
    }

    protected MasterDetailLevel getDetailLevelToEncode(FacesContext fc, MasterDetail masterDetail, MasterDetailLevel mdlToProcess, MasterDetailLevel mdlToGo) {
        if (masterDetail.getSelectLevelListener() != null) {
            SelectLevelEvent selectLevelEvent = new SelectLevelEvent((UIComponent)masterDetail, mdlToProcess.getLevel(), mdlToGo.getLevel());
            int levelToEncode = (Integer)masterDetail.getSelectLevelListener().invoke(fc.getELContext(), new Object[]{selectLevelEvent});
            if (levelToEncode != mdlToGo.getLevel()) {
                return masterDetail.getDetailLevelByLevel(levelToEncode);
            }
        }
        return mdlToGo;
    }

    protected void encodeMarkup(FacesContext fc, MasterDetail masterDetail, MasterDetailLevel mdl) throws IOException {
        if (mdl == null) {
            throw new FacesException("MasterDetailLevel must be nested inside a MasterDetail component!");
        }
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = masterDetail.getClientId(fc);
        String styleClass = masterDetail.getStyleClass() == null ? "pe-master-detail" : "pe-master-detail " + masterDetail.getStyleClass();
        writer.startElement("div", (UIComponent)masterDetail);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (masterDetail.getStyle() != null) {
            writer.writeAttribute("style", (Object)masterDetail.getStyle(), "style");
        }
        if (masterDetail.isShowBreadcrumb()) {
            if (masterDetail.isBreadcrumbAboveHeader()) {
                this.renderBreadcrumb(fc, masterDetail, mdl);
                this.encodeFacet(fc, (UIComponent)masterDetail, FACET_HEADER);
            } else {
                this.encodeFacet(fc, (UIComponent)masterDetail, FACET_HEADER);
                this.renderBreadcrumb(fc, masterDetail, mdl);
            }
        } else {
            this.encodeFacet(fc, (UIComponent)masterDetail, FACET_HEADER);
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_detaillevel"), "id");
        writer.writeAttribute("class", (Object)"pe-master-detail-level", null);
        Object contextValue = null;
        String contextVar = mdl.getContextVar();
        if (!LangUtils.isValueBlank((String)contextVar)) {
            contextValue = masterDetail.getContextValueFromFlow(fc, mdl, true);
        }
        if (contextValue != null) {
            Map requestMap = fc.getExternalContext().getRequestMap();
            requestMap.put(contextVar, contextValue);
        }
        mdl.encodeAll(fc);
        if (contextValue != null) {
            fc.getExternalContext().getRequestMap().remove(contextVar);
        }
        writer.endElement("div");
        this.encodeFacet(fc, (UIComponent)masterDetail, FACET_FOOTER);
        writer.endElement("div");
    }

    protected void renderBreadcrumb(FacesContext fc, MasterDetail masterDetail, MasterDetailLevel mdl) throws IOException {
        BreadCrumb breadcrumb = masterDetail.getBreadcrumb();
        this.updateBreadcrumb(fc, breadcrumb, masterDetail, mdl);
        breadcrumb.encodeAll(fc);
    }

    protected void encodeFacet(FacesContext fc, UIComponent component, String name) throws IOException {
        UIComponent facet = component.getFacet(name);
        if (ComponentUtils.shouldRenderFacet((UIComponent)facet)) {
            facet.encodeAll(fc);
        }
    }

    protected void updateBreadcrumb(FacesContext fc, BreadCrumb breadcrumb, MasterDetail masterDetail, MasterDetailLevel mdlToRender) throws IOException {
        boolean lastMdlFound = false;
        int levelToRender = mdlToRender.getLevel();
        boolean isShowAllBreadcrumbItems = masterDetail.isShowAllBreadcrumbItems();
        for (UIComponent child : masterDetail.getChildren()) {
            if (!(child instanceof MasterDetailLevel)) continue;
            MasterDetailLevel mdl = (MasterDetailLevel)child;
            DefaultMenuItem menuItem = this.getMenuItemByLevel(breadcrumb, masterDetail, mdl);
            if (menuItem == null) {
                return;
            }
            if (!child.isRendered()) {
                menuItem.setRendered(false);
                if (lastMdlFound) continue;
                lastMdlFound = mdl.getLevel() == mdlToRender.getLevel();
                continue;
            }
            if (lastMdlFound && !isShowAllBreadcrumbItems) {
                menuItem.setRendered(false);
            } else {
                UIComponent facet;
                boolean putContext;
                menuItem.setRendered(true);
                Object contextValue = masterDetail.getContextValueFromFlow(fc, mdl, mdl.getLevel() == mdlToRender.getLevel());
                String contextVar = mdl.getContextVar();
                boolean bl = putContext = !LangUtils.isValueBlank((String)contextVar) && contextValue != null;
                if (putContext) {
                    Map requestMap = fc.getExternalContext().getRequestMap();
                    requestMap.put(contextVar, contextValue);
                }
                if (ComponentUtils.shouldRenderFacet((UIComponent)(facet = mdl.getFacet(FACET_LABEL)))) {
                    ResponseWriter writer = fc.getResponseWriter();
                    FastStringWriter fsw = new FastStringWriter();
                    ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fsw);
                    fc.setResponseWriter(clonedWriter);
                    facet.encodeAll(fc);
                    fc.setResponseWriter(writer);
                    menuItem.setValue((Object)StringEscapeUtils.unescapeHtml4((String)fsw.toString()));
                } else {
                    menuItem.setValue((Object)mdl.getLevelLabel());
                }
                if (isShowAllBreadcrumbItems && lastMdlFound) {
                    menuItem.setDisabled(true);
                } else {
                    menuItem.setDisabled(mdl.isLevelDisabled());
                }
                if (putContext) {
                    fc.getExternalContext().getRequestMap().remove(contextVar);
                }
                if (!menuItem.isDisabled()) {
                    this.updateUIParameter((MenuItem)menuItem, masterDetail.getClientId(fc) + "_currentLevel", levelToRender);
                }
            }
            if (lastMdlFound) continue;
            lastMdlFound = mdl.getLevel() == mdlToRender.getLevel();
        }
    }

    protected DefaultMenuItem getMenuItemByLevel(BreadCrumb breadcrumb, MasterDetail masterDetail, MasterDetailLevel mdl) {
        String menuItemId = masterDetail.getId() + "_bcItem_" + mdl.getLevel();
        for (MenuElement child : breadcrumb.getModel().getElements()) {
            if (!menuItemId.equals(child.getId())) continue;
            return (DefaultMenuItem)child;
        }
        return null;
    }

    protected void updateUIParameter(MenuItem menuItem, String name, Object value) {
        Map params = menuItem.getParams();
        if (params == null) {
            return;
        }
        for (String key : params.keySet()) {
            if (!key.equals(name)) continue;
            params.remove(key);
            menuItem.setParam(name, value);
            break;
        }
    }

    public void encodeChildren(FacesContext fc, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static Object getConvertedSubmittedValue(FacesContext fc, EditableValueHolder evh) {
        Object submittedValue = evh.getSubmittedValue();
        if (submittedValue == null) {
            return null;
        }
        try {
            Converter converter;
            UIComponent component = (UIComponent)evh;
            Renderer renderer = MasterDetailRenderer.getRenderer(fc, component);
            if (renderer != null) {
                return renderer.getConvertedValue(fc, component, submittedValue);
            }
            if (submittedValue instanceof String && (converter = ComponentUtils.getConverter((FacesContext)fc, (UIComponent)component)) != null) {
                return converter.getAsObject(fc, component, (String)submittedValue);
            }
        }
        catch (Exception e) {
            return null;
        }
        return submittedValue;
    }

    public static Renderer getRenderer(FacesContext fc, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType != null) {
            return fc.getRenderKit().getRenderer(component.getFamily(), rendererType);
        }
        return null;
    }
}

