/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.row.Row;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.exporter.Exporter;
import org.primefaces.extensions.util.ExtLangUtils;

public class PDFExporter
extends Exporter {
    private Font cellFont;
    private Font facetFont;
    private Color facetBackground;
    private Float facetFontSize;
    private Color facetFontColor;
    private String facetFontStyle;
    private String fontName;
    private Float cellFontSize;
    private Color cellFontColor;
    private String cellFontStyle;
    private int datasetPadding;
    private String orientation;

    @Override
    public void export(ActionEvent event, String tableId, FacesContext context, String filename, String tableTitle, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean subTable) throws IOException {
        try {
            Document document = new Document();
            if (this.orientation.equalsIgnoreCase("Landscape")) {
                document.setPageSize(PageSize.A4.rotate());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            String tokenString = ExtLangUtils.normalizeSpace(tableId.replace(',', ' '));
            StringTokenizer st = new StringTokenizer(tokenString, " ");
            while (st.hasMoreElements()) {
                PdfPTable pdf;
                String tableName = (String)st.nextElement();
                UIComponent component = SearchExpressionFacade.resolveComponent((FacesContext)context, (UIComponent)event.getComponent(), (String)tableName);
                if (component == null) {
                    throw new FacesException("Cannot find component \"" + tableName + "\" in view.");
                }
                if (!(component instanceof DataTable) && !(component instanceof DataList)) {
                    throw new FacesException("Unsupported datasource target:\"" + component.getClass().getName() + "\", exporter must target a PrimeFaces DataTable/DataList.");
                }
                if (!component.isRendered()) continue;
                if (!document.isOpen()) {
                    document.open();
                }
                if (tableTitle != null && !tableTitle.isEmpty() && !tableId.contains(",")) {
                    Font tableTitleFont = FontFactory.getFont((String)"Times", (String)encodingType, (float)12.0f, (int)1);
                    Paragraph title = new Paragraph(tableTitle, tableTitleFont);
                    document.add((Element)title);
                    Paragraph preface = new Paragraph();
                    PDFExporter.addEmptyLine(preface, 3);
                    document.add((Element)preface);
                }
                if (component instanceof DataList) {
                    DataList list = (DataList)component;
                    pdf = this.exportPDFTable(list, pageOnly, encodingType);
                } else {
                    DataTable table = (DataTable)component;
                    pdf = this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType, subTable);
                }
                if (pdf != null) {
                    document.add((Element)pdf);
                }
                Paragraph preface = new Paragraph();
                PDFExporter.addEmptyLine(preface, this.datasetPadding);
                document.add((Element)preface);
            }
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, filename);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected PdfPTable exportPDFTable(FacesContext context, DataTable table, boolean pageOnly, boolean selectionOnly, String encoding, boolean subTable) {
        PdfPTable pdfTable;
        if (!"-".equalsIgnoreCase(encoding)) {
            this.createCustomFonts(encoding);
        }
        int columnsCount = PDFExporter.getColumnsCount(table);
        if (subTable) {
            int subTableCount = table.getRowCount();
            SubTable subtable = table.getSubTable();
            int subTableColumnsCount = PDFExporter.getColumnsCount(subtable);
            pdfTable = new PdfPTable(subTableColumnsCount);
            if (table.getHeader() != null) {
                this.tableFacet(context, pdfTable, table, subTableColumnsCount, Exporter.ColumnType.HEADER.facet());
            }
            this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.HEADER.facet());
            int i = 0;
            while (subTableCount > 0) {
                --subTableCount;
                table.setRowIndex(i);
                ++i;
                subtable = table.getSubTable();
                if (subtable.getHeader() != null) {
                    this.tableFacet(context, pdfTable, subtable, subTableColumnsCount, Exporter.ColumnType.HEADER.facet());
                }
                if (PDFExporter.hasHeaderColumn(subtable)) {
                    this.addColumnFacets(subtable, pdfTable, Exporter.ColumnType.HEADER);
                }
                if (pageOnly) {
                    this.exportPageOnly(table, pdfTable);
                } else if (selectionOnly) {
                    this.exportSelectionOnly(context, table, pdfTable);
                } else {
                    this.subTableExportAll(subtable, pdfTable);
                }
                if (PDFExporter.hasFooterColumn(subtable)) {
                    this.addColumnFacets(subtable, pdfTable, Exporter.ColumnType.FOOTER);
                }
                if (subtable.getFooter() != null) {
                    this.tableFacet(context, pdfTable, subtable, subTableColumnsCount, Exporter.ColumnType.FOOTER.facet());
                }
                subtable.setRowIndex(-1);
            }
            this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.FOOTER.facet());
            if (table.hasFooterColumn()) {
                this.tableFacet(context, pdfTable, table, subTableColumnsCount, Exporter.ColumnType.FOOTER.facet());
            }
        } else {
            if (columnsCount == 0) {
                return null;
            }
            pdfTable = new PdfPTable(columnsCount);
            if (table.getHeader() != null) {
                this.tableFacet(context, pdfTable, table, columnsCount, Exporter.ColumnType.HEADER.facet());
            }
            if (PDFExporter.hasHeaderColumn(table)) {
                this.addColumnFacets(table, pdfTable, Exporter.ColumnType.HEADER);
            }
            if (pageOnly) {
                this.exportPageOnly(table, pdfTable);
            } else if (selectionOnly) {
                this.exportSelectionOnly(context, table, pdfTable);
            } else {
                this.exportAll(table, pdfTable);
            }
            if (table.hasFooterColumn()) {
                this.addColumnFacets(table, pdfTable, Exporter.ColumnType.FOOTER);
            }
            if (table.getFooter() != null) {
                this.tableFacet(context, pdfTable, table, columnsCount, Exporter.ColumnType.FOOTER.facet());
            }
            table.setRowIndex(-1);
        }
        return pdfTable;
    }

    protected PdfPTable exportPDFTable(DataList list, boolean pageOnly, String encoding) {
        if (!"-".equalsIgnoreCase(encoding)) {
            this.createCustomFonts(encoding);
        }
        int first = list.getFirst();
        int rowCount = list.getRowCount();
        int rowsToExport = first + list.getRows();
        PdfPTable pdfTable = new PdfPTable(1);
        if (list.getHeader() != null) {
            String value = this.exportValue(FacesContext.getCurrentInstance(), list.getHeader());
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
            if (this.facetBackground != null) {
                cell.setBackgroundColor(this.facetBackground);
            }
            cell.setHorizontalAlignment(1);
            pdfTable.addCell(cell);
            pdfTable.completeRow();
        }
        StringBuilder builder = new StringBuilder();
        String output = pageOnly ? this.exportPageOnly(first, list, rowsToExport, builder) : this.exportAll(list, rowCount, builder);
        pdfTable.addCell((Phrase)new Paragraph(output, this.cellFont));
        pdfTable.completeRow();
        if (list.getFooter() != null) {
            String value = this.exportValue(FacesContext.getCurrentInstance(), list.getFooter());
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
            if (this.facetBackground != null) {
                cell.setBackgroundColor(this.facetBackground);
            }
            cell.setHorizontalAlignment(1);
            pdfTable.addCell(cell);
            pdfTable.completeRow();
        }
        return pdfTable;
    }

    protected void exportPageOnly(DataTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.HEADER.facet());
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, pdfTable, rowIndex);
        }
        this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.FOOTER.facet());
    }

    protected String exportPageOnly(int first, DataList list, int rowsToExport, StringBuilder input) {
        String output = "";
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            output = this.addColumnValues(list, input);
        }
        return output;
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, PdfPTable pdfTable) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, pdfTable);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                Collection collection = (Collection)selection;
                for (Object o : collection) {
                    requestMap.put(var, o);
                    this.exportCells(table, pdfTable);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, pdfTable);
            }
        }
    }

    protected void exportAll(DataTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        boolean lazy = table.isLazy();
        if (lazy) {
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.clearLazyCache();
                table.loadLazyData();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, pdfTable, rowIndex);
            }
            table.setFirst(first);
            table.setRowIndex(-1);
            table.clearLazyCache();
            table.loadLazyData();
        } else {
            this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.HEADER.facet());
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, pdfTable, rowIndex);
            }
            this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.FOOTER.facet());
            table.setFirst(first);
        }
    }

    protected void subTableExportAll(SubTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.HEADER.facet());
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.subTableExportRow(table, pdfTable, rowIndex);
        }
        this.tableColumnGroup(pdfTable, table, Exporter.ColumnType.FOOTER.facet());
        table.setFirst(first);
    }

    protected String exportAll(DataList list, int rowCount, StringBuilder input) {
        String output = "";
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            list.setRowIndex(rowIndex);
            output = this.addColumnValues(list, input);
        }
        return output;
    }

    protected void tableFacet(FacesContext context, PdfPTable pdfTable, DataTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue;
            if (component instanceof HtmlCommandButton) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof HtmlCommandLink) {
                headerValue = this.exportValue(context, component);
            } else {
                if (component instanceof UIPanel) {
                    StringBuilder header = new StringBuilder("");
                    for (UIComponent child : component.getChildren()) {
                        String headerValue2 = this.exportValue(context, child);
                        header.append(headerValue2);
                    }
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(header.toString(), this.facetFont));
                    if (this.facetBackground != null) {
                        cell.setBackgroundColor(this.facetBackground);
                    }
                    cell.setHorizontalAlignment(1);
                    cell.setColspan(columnCount);
                    pdfTable.addCell(cell);
                    pdfTable.completeRow();
                    return;
                }
                headerValue = PDFExporter.exportFacetValue(context, component);
            }
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(headerValue, this.facetFont));
            if (this.facetBackground != null) {
                cell.setBackgroundColor(this.facetBackground);
            }
            cell.setHorizontalAlignment(1);
            cell.setColspan(columnCount);
            pdfTable.addCell(cell);
            pdfTable.completeRow();
        }
    }

    protected void tableFacet(FacesContext context, PdfPTable pdfTable, SubTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue;
            if (component instanceof HtmlCommandButton) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof HtmlCommandLink) {
                headerValue = this.exportValue(context, component);
            } else {
                if (component instanceof UIPanel) {
                    StringBuilder header = new StringBuilder("");
                    for (UIComponent child : component.getChildren()) {
                        String headerValue2 = this.exportValue(context, child);
                        header.append(headerValue2);
                    }
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(header.toString(), this.facetFont));
                    if (this.facetBackground != null) {
                        cell.setBackgroundColor(this.facetBackground);
                    }
                    cell.setHorizontalAlignment(1);
                    cell.setColspan(columnCount);
                    pdfTable.addCell(cell);
                    pdfTable.completeRow();
                    return;
                }
                headerValue = PDFExporter.exportFacetValue(context, component);
            }
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(headerValue, this.facetFont));
            if (this.facetBackground != null) {
                cell.setBackgroundColor(this.facetBackground);
            }
            cell.setHorizontalAlignment(1);
            cell.setColspan(columnCount);
            pdfTable.addCell(cell);
            pdfTable.completeRow();
        }
    }

    protected void tableColumnGroup(PdfPTable pdfTable, DataTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof Row)) continue;
                Row row = (Row)component;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    if (!column.isRendered() || !column.isExportable()) continue;
                    String value = facetType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet()) ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
                    if (this.facetBackground != null) {
                        cell.setBackgroundColor(this.facetBackground);
                    }
                    if (rowSpan > 1) {
                        cell.setVerticalAlignment(1);
                        cell.setRowspan(rowSpan);
                    }
                    if (colSpan > 1) {
                        cell.setHorizontalAlignment(1);
                        cell.setColspan(colSpan);
                    }
                    if (facetType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet())) {
                        cell.setHorizontalAlignment(1);
                    }
                    pdfTable.addCell(cell);
                }
            }
        }
        pdfTable.completeRow();
    }

    protected void tableColumnGroup(PdfPTable pdfTable, SubTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof Row)) continue;
                Row row = (Row)component;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    String value = facetType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet()) ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
                    if (this.facetBackground != null) {
                        cell.setBackgroundColor(this.facetBackground);
                    }
                    if (rowSpan > 1) {
                        cell.setVerticalAlignment(1);
                        cell.setRowspan(rowSpan);
                    }
                    if (colSpan > 1) {
                        cell.setHorizontalAlignment(1);
                        cell.setColspan(colSpan);
                    }
                    if (facetType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet())) {
                        cell.setHorizontalAlignment(1);
                    }
                    pdfTable.addCell(cell);
                }
            }
        }
        pdfTable.completeRow();
    }

    protected void exportRow(DataTable table, PdfPTable pdfTable, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, pdfTable);
        SummaryRow sr = table.getSummaryRow();
        if (sr != null && sr.isInView()) {
            for (UIComponent summaryComponent : sr.getChildren()) {
                UIColumn column = (UIColumn)summaryComponent;
                StringBuilder builder = new StringBuilder();
                for (UIComponent component : column.getChildren()) {
                    String value;
                    if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
                    builder.append(value);
                }
                int rowSpan = column.getRowspan();
                int colSpan = column.getColspan();
                PdfPCell cell = new PdfPCell((Phrase)new Paragraph(builder.toString(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                if (rowSpan > 1) {
                    cell.setVerticalAlignment(1);
                    cell.setRowspan(rowSpan);
                }
                if (colSpan > 1) {
                    cell.setHorizontalAlignment(1);
                    cell.setColspan(colSpan);
                }
                pdfTable.addCell(cell);
            }
        }
    }

    protected void subTableExportRow(SubTable table, PdfPTable pdfTable, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.subTableExportCells(table, pdfTable);
    }

    protected void exportCells(DataTable table, PdfPTable pdfTable) {
        RowExpansion rowExpansion;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (col.getSelectionMode() != null) {
                pdfTable.addCell((Phrase)new Paragraph(col.getSelectionMode(), this.cellFont));
                continue;
            }
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont, col);
        }
        pdfTable.completeRow();
        if (table.getRowIndex() == 0) {
            for (UIComponent component : table.getChildren()) {
                if (!(component instanceof RowExpansion) || (rowExpansion = (RowExpansion)component).getChildren() == null) continue;
                if (rowExpansion.getChildren().get(0) instanceof DataTable) {
                    DataTable childTable = (DataTable)rowExpansion.getChildren().get(0);
                    childTable.setRowIndex(-1);
                }
                if (!(rowExpansion.getChildren().get(0) instanceof DataList)) continue;
                DataList childList = (DataList)rowExpansion.getChildren().get(0);
                childList.setRowIndex(-1);
            }
        }
        for (UIComponent component : table.getChildren()) {
            if (component instanceof RowExpansion && (rowExpansion = (RowExpansion)component).getChildren() != null) {
                for (int i = 0; i < rowExpansion.getChildren().size(); ++i) {
                    PdfPCell cell;
                    PdfPTable pdfTableChild;
                    UIComponent child = (UIComponent)rowExpansion.getChildren().get(i);
                    if (child instanceof DataTable) {
                        DataTable childTable = (DataTable)child;
                        pdfTableChild = this.exportPDFTable(null, childTable, false, false, "-", false);
                        cell = new PdfPCell();
                        cell.addElement((Element)pdfTableChild);
                        cell.setColspan(pdfTable.getNumberOfColumns());
                        pdfTable.addCell(cell);
                    }
                    if (!(child instanceof DataList)) continue;
                    DataList list = (DataList)child;
                    pdfTableChild = this.exportPDFTable(list, false, "-");
                    pdfTableChild.getDefaultCell().setBorder(0);
                    cell = new PdfPCell();
                    cell.addElement((Element)pdfTableChild);
                    cell.setColspan(pdfTable.getNumberOfColumns());
                }
            }
            pdfTable.completeRow();
        }
    }

    protected void subTableExportCells(SubTable table, PdfPTable pdfTable) {
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont, col);
        }
    }

    protected void addColumnFacets(DataTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (UIColumn col : table.getColumns()) {
            PdfPCell cell;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (col.getHeaderText() != null && columnType.name().equalsIgnoreCase(Exporter.ColumnType.HEADER.facet())) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getHeaderText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                cell.setHorizontalAlignment(1);
                pdfTable.addCell(cell);
                continue;
            }
            if (col.getFooterText() != null && columnType.name().equalsIgnoreCase(Exporter.ColumnType.FOOTER.facet())) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getFooterText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            this.addColumnValue(pdfTable, col.getFacet(columnType.facet()), this.facetFont, columnType.name());
        }
    }

    protected void addColumnFacets(SubTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (UIColumn col : table.getColumns()) {
            PdfPCell cell;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (col.getHeaderText() != null && columnType.name().equalsIgnoreCase(Exporter.ColumnType.HEADER.facet())) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getHeaderText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                cell.setHorizontalAlignment(1);
                pdfTable.addCell(cell);
                continue;
            }
            if (col.getFooterText() != null && columnType.name().equalsIgnoreCase(Exporter.ColumnType.FOOTER.facet())) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getFooterText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            this.addColumnValue(pdfTable, col.getFacet(columnType.facet()), this.facetFont, columnType.name());
        }
    }

    protected void addColumnValue(PdfPTable pdfTable, UIComponent component, Font font, String columnType) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, font));
        if (this.facetBackground != null) {
            cell.setBackgroundColor(this.facetBackground);
        }
        cell = columnType.equalsIgnoreCase(Exporter.ColumnType.HEADER.facet()) ? this.addFacetAlignments(component, cell) : this.addColumnAlignments(component, cell);
        pdfTable.addCell(cell);
    }

    protected void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, Font font, UIColumn column) {
        PdfPCell cell;
        FacesContext context = FacesContext.getCurrentInstance();
        if (column.getExportFunction() != null) {
            cell = new PdfPCell((Phrase)new Paragraph(PDFExporter.exportColumnByFunction(context, column), font));
        } else {
            StringBuilder builder = new StringBuilder();
            for (UIComponent component : components) {
                String value;
                if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
                builder.append(value);
            }
            cell = new PdfPCell((Phrase)new Paragraph(builder.toString(), font));
            for (UIComponent component : components) {
                cell = this.addColumnAlignments(component, cell);
            }
        }
        if (cell != null) {
            pdfTable.addCell(cell);
        }
    }

    protected PdfPCell addColumnAlignments(UIComponent component, PdfPCell cell) {
        if (component instanceof HtmlOutputText) {
            HtmlOutputText output = (HtmlOutputText)component;
            if (output.getStyle() != null && output.getStyle().contains("left")) {
                cell.setHorizontalAlignment(0);
            }
            if (output.getStyle() != null && output.getStyle().contains("right")) {
                cell.setHorizontalAlignment(2);
            }
            if (output.getStyle() != null && output.getStyle().contains("center")) {
                cell.setHorizontalAlignment(1);
            }
        }
        return cell;
    }

    protected PdfPCell addFacetAlignments(UIComponent component, PdfPCell cell) {
        if (component instanceof HtmlOutputText) {
            HtmlOutputText output = (HtmlOutputText)component;
            if (output.getStyle() != null && output.getStyle().contains("left")) {
                cell.setHorizontalAlignment(0);
            } else if (output.getStyle() != null && output.getStyle().contains("right")) {
                cell.setHorizontalAlignment(2);
            } else {
                cell.setHorizontalAlignment(1);
            }
        }
        return cell;
    }

    @Override
    public void customFormat(String facetBackground, String facetFontSize, String facetFontColor, String facetFontStyle, String fontName, String cellFontSize, String cellFontColor, String cellFontStyle, String datasetPadding, String orientation) {
        this.facetFontSize = Float.valueOf(Float.parseFloat(facetFontSize));
        this.cellFontSize = Float.valueOf(Float.parseFloat(cellFontSize));
        this.datasetPadding = Integer.parseInt(datasetPadding);
        this.orientation = orientation;
        if (facetBackground != null) {
            this.facetBackground = Color.decode(facetBackground);
        }
        if (facetFontColor != null) {
            this.facetFontColor = Color.decode(facetFontColor);
        }
        if (cellFontColor != null) {
            this.cellFontColor = Color.decode(cellFontColor);
        }
        if (fontName != null) {
            this.fontName = fontName;
        }
        if (facetFontStyle.equalsIgnoreCase("NORMAL")) {
            this.facetFontStyle = "0";
        }
        if (facetFontStyle.equalsIgnoreCase("BOLD")) {
            this.facetFontStyle = "1";
        }
        if (facetFontStyle.equalsIgnoreCase("ITALIC")) {
            this.facetFontStyle = "2";
        }
        if (cellFontStyle.equalsIgnoreCase("NORMAL")) {
            this.cellFontStyle = "0";
        }
        if (cellFontStyle.equalsIgnoreCase("BOLD")) {
            this.cellFontStyle = "1";
        }
        if (cellFontStyle.equalsIgnoreCase("ITALIC")) {
            this.cellFontStyle = "2";
        }
    }

    protected void createCustomFonts(String encoding) {
        if (this.fontName != null && FontFactory.getFont((String)this.fontName).getBaseFont() != null) {
            this.cellFont = FontFactory.getFont((String)this.fontName, (String)encoding);
            this.facetFont = FontFactory.getFont((String)this.fontName, (String)encoding, (float)12.0f, (int)1);
        } else {
            this.cellFont = FontFactory.getFont((String)"Times", (String)encoding);
            this.facetFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        }
        if (this.facetFontColor != null) {
            this.facetFont.setColor(this.facetFontColor);
        }
        if (this.facetFontSize != null) {
            this.facetFont.setSize(this.facetFontSize.floatValue());
        }
        if (this.facetFontStyle != null) {
            this.facetFont.setStyle(this.facetFontStyle);
        }
        if (this.cellFontColor != null) {
            this.cellFont.setColor(this.cellFontColor);
        }
        if (this.cellFontSize != null) {
            this.cellFont.setSize(this.cellFontSize.floatValue());
        }
        if (this.cellFontStyle != null) {
            this.cellFont.setStyle(this.cellFontStyle);
        }
    }

    private static void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    protected void writePDFToResponse(ExternalContext externalContext, ByteArrayOutputStream baos, String fileName) throws IOException {
        externalContext.setResponseContentType("application/pdf");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        externalContext.setResponseContentLength(baos.size());
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
        OutputStream out = externalContext.getResponseOutputStream();
        baos.writeTo(out);
        externalContext.responseFlushBuffer();
    }
}

