/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.gchart.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.extensions.component.gchart.model.DefaultGChartModel;
import org.primefaces.extensions.component.gchart.model.DefaultGChartModelRow;
import org.primefaces.extensions.component.gchart.model.GChartModel;
import org.primefaces.extensions.component.gchart.model.GChartModelRow;
import org.primefaces.extensions.component.gchart.model.GChartType;
import org.primefaces.model.TreeNode;

public class GChartModelBuilder {
    private final List<GChartModelRow> rows = new ArrayList<GChartModelRow>(0);
    private GChartType gChartType;
    private final Map<String, Object> options = new HashMap<String, Object>(0);
    private final List<Object> columns = new ArrayList<Object>(0);

    public GChartModelBuilder setChartType(GChartType chartType) {
        if (this.gChartType != null) {
            throw new IllegalStateException("GChart Type already set");
        }
        this.gChartType = chartType;
        return this;
    }

    public GChartModelBuilder importTreeNode(TreeNode root) {
        String label = String.valueOf(root.getData());
        String parentLabel = root.getParent() != null ? String.valueOf(root.getParent().getData()) : "";
        this.addRow(label, parentLabel);
        for (TreeNode node : root.getChildren()) {
            this.importTreeNode(node);
        }
        return this;
    }

    public GChartModelBuilder addColumns(Object ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public GChartModelBuilder addColumns(Collection<Object> columns) {
        this.columns.addAll(columns);
        return this;
    }

    public GChartModelBuilder addRow(String label, Object ... objects) {
        this.rows.add(new DefaultGChartModelRow(label, Arrays.asList(objects)));
        return this;
    }

    public GChartModelBuilder addRow(String label, Collection<Object> objects) {
        this.rows.add(new DefaultGChartModelRow(label, objects));
        return this;
    }

    public GChartModelBuilder addOption(String name, Object value) {
        this.options.put(name, value);
        return this;
    }

    public GChartModel build() {
        return new DefaultGChartModel(this.rows, this.gChartType, this.options, this.columns);
    }
}

