/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.layout;

import java.io.IOException;
import java.io.Writer;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.layout.Layout;
import org.primefaces.extensions.model.layout.LayoutOptions;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class LayoutRenderer
extends CoreRenderer {
    public void decode(FacesContext fc, UIComponent component) {
        this.decodeBehaviors(fc, component);
    }

    public void encodeBegin(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Layout layout = (Layout)component;
        boolean buildOptions = layout.getOptions() == null;
        layout.setBuildOptions(buildOptions);
        if (buildOptions) {
            FastStringWriter fsw = new FastStringWriter();
            layout.setOriginalWriter(writer);
            layout.setFastStringWriter(fsw);
            fc.setResponseWriter(writer.cloneWithWriter((Writer)fsw));
            writer = fc.getResponseWriter();
        }
        if (layout.isElementLayout()) {
            writer.startElement("div", (UIComponent)layout);
            writer.writeAttribute("id", (Object)layout.getClientId(fc), "id");
            if (layout.getStyle() != null) {
                writer.writeAttribute("style", (Object)layout.getStyle(), "style");
            }
            if (layout.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)layout.getStyleClass(), "styleClass");
            }
        }
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Layout layout = (Layout)component;
        if (layout.isElementLayout()) {
            if (!layout.isStateCookie()) {
                String clientId = layout.getClientId(fc);
                writer.startElement("input", null);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("id", (Object)(clientId + "_state"), null);
                writer.writeAttribute("name", (Object)(clientId + "_state"), null);
                writer.writeAttribute("autocomplete", (Object)"off", null);
                writer.endElement("input");
            }
            writer.endElement("div");
        }
        if (layout.isBuildOptions()) {
            fc.setResponseWriter(layout.getOriginalWriter());
            this.encodeScript(fc, layout);
            fc.getResponseWriter().write(layout.getFastStringWriter().toString());
            layout.removeOptions();
            layout.setOriginalWriter(null);
            layout.setFastStringWriter(null);
        } else {
            this.encodeScript(fc, layout);
        }
        layout.setBuildOptions(false);
    }

    protected void encodeScript(FacesContext fc, Layout layout) throws IOException {
        ValueExpression stateVE;
        String clientId = layout.getClientId(fc);
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.init("ExtLayout", layout.resolveWidgetVar(), clientId);
        wb.attr("clientState", Boolean.valueOf(layout.isStateCookie()));
        wb.attr("full", layout.isFullPage(), false);
        if (layout.isNested()) {
            wb.attr("parent", layout.getParent().getClientId(fc));
        }
        if ((stateVE = layout.getValueExpression(Layout.PropertyKeys.state.toString())) != null && !layout.isFullPage() && !layout.isStateCookie()) {
            wb.attr("serverState", Boolean.valueOf(true));
            String state = layout.getState();
            if (!LangUtils.isValueBlank((String)state)) {
                wb.attr("state", state);
            } else {
                wb.nativeAttr("state", "{}");
            }
        } else {
            wb.attr("serverState", Boolean.valueOf(false));
        }
        Object layoutOptions = layout.getOptions();
        if (layoutOptions instanceof LayoutOptions) {
            LayoutOptions options = (LayoutOptions)layoutOptions;
            wb.append(",options:" + options.toJson());
        } else if (layoutOptions instanceof String) {
            wb.append(",options:" + layoutOptions.toString());
        } else {
            wb.append(",options:{}");
        }
        this.encodeClientBehaviors(fc, layout);
        wb.finish();
    }
}

