/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.util.Objects;
import org.primefaces.util.LangUtils;

public class ExtLangUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private ExtLangUtils() {
    }

    public static <T> boolean contains(T[] array, T value) {
        if (array == null || value == null) {
            return false;
        }
        for (T entry : array) {
            if (!Objects.equals(value, entry)) continue;
            return true;
        }
        return false;
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static int countMatches(String str, char c) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (char current : str.toCharArray()) {
            if (current != c) continue;
            ++count;
        }
        return count;
    }

    public static String defaultString(String str) {
        return str == null ? "" : str;
    }

    public static String defaultString(String str, String def) {
        return str == null ? def : str;
    }

    public static String deleteWhitespace(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static String[] subarray(String[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return new String[0];
        }
        String[] subarray = new String[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static String normalizeSpace(String s) {
        return s.replaceAll("\\s+", " ").trim();
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return seq.toString().indexOf(searchSeq.toString(), startPos);
    }

    public static String replace(String text, String searchString, String replacement) {
        if (LangUtils.isValueEmpty((String)text) || LangUtils.isValueEmpty((String)searchString) || replacement == null) {
            return text;
        }
        int max = -1;
        int start = 0;
        int end = ExtLangUtils.indexOf(text, searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = ExtLangUtils.indexOf(text, searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String unescapeXml(String text) {
        int n = text.length();
        StringBuilder result = new StringBuilder(n);
        int i = 0;
        while (i < n) {
            char charAt = text.charAt(i);
            if (charAt != '&') {
                result.append(charAt);
                ++i;
                continue;
            }
            if (text.startsWith("&amp;", i)) {
                result.append('&');
                i += 5;
                continue;
            }
            if (text.startsWith("&apos;", i)) {
                result.append('\'');
                i += 6;
                continue;
            }
            if (text.startsWith("&quot;", i)) {
                result.append('\"');
                i += 6;
                continue;
            }
            if (text.startsWith("&lt;", i)) {
                result.append('<');
                i += 4;
                continue;
            }
            if (text.startsWith("&gt;", i)) {
                result.append('>');
                i += 4;
                continue;
            }
            ++i;
        }
        return result.toString();
    }
}

