/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.badge;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.context.FacesContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.badge.Badge;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class BadgeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Badge badge = (Badge)component;
        this.encodeScript(context, badge);
    }

    private void encodeScript(FacesContext context, Badge badge) throws IOException {
        UIComponent targetComponent;
        String target = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)badge, (String)badge.getFor());
        if (this.isValueBlank(target)) {
            target = badge.getParent().getClientId(context);
        }
        if (!((targetComponent = SearchExpressionFacade.resolveComponent((FacesContext)context, (UIComponent)badge, (String)target)) instanceof UICommand) && !(targetComponent instanceof UIOutcomeTarget)) {
            throw new FacesException("Badge must use for=\"target\" or be nested inside an button!");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtBadge", badge.resolveWidgetVar(), badge.getClientId(context));
        wb.attr("target", target);
        wb.attr("color", badge.getColor());
        wb.attr("position", badge.getPosition());
        if (badge.getContent() != null) {
            wb.attr("content", badge.getContent());
        }
        wb.finish();
    }
}

