/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.component.commandbutton.CommandButtonRenderer;

public class CommandButtonSingleClickRenderer
extends CommandButtonRenderer {
    protected void encodeMarkup(FacesContext context, CommandButton button) throws IOException {
        if (this.isEligible(button)) {
            String widgetVar = button.resolveWidgetVar(context);
            button.setOnclick(this.prefix(button.getOnclick(), this.getToggleJS(widgetVar, false)));
            button.setOncomplete(this.prefix(button.getOncomplete(), this.getToggleJS(widgetVar, true)));
        }
        super.encodeMarkup(context, button);
    }

    protected boolean isEligible(CommandButton button) {
        return button.isAjax() && button.isRendered() && !button.isDisabled() && !this.isConfirmation(button);
    }

    protected boolean isConfirmation(CommandButton button) {
        String styleClass = button.getStyleClass();
        return styleClass != null && styleClass.contains("ui-confirmdialog");
    }

    protected String getToggleJS(String widgetVar, boolean enabled) {
        return String.format("var w=PF('%s');if(w){w.%sable();};", widgetVar, enabled ? "en" : "dis");
    }

    protected String prefix(String base, String prefix) {
        return base == null ? prefix : prefix + base;
    }
}

