/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractInputComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.findby.FindByParentPartialId;

public abstract class CascadeSelect
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindByParentPartialId(value="_panel", searchFromRoot=true)
    private WebElement panel;

    public boolean isItemSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemSelect");
    }

    public void toggleDropdown() {
        if (this.getPanel().isDisplayed()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public void show() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && !panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void hide() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void enable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable();"), (Object[])new Object[0]);
    }

    public void disable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable();"), (Object[])new Object[0]);
    }

    public void select(String label) {
        if (this.isSelected(label) || !this.isEnabled()) {
            return;
        }
        if (!this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
        boolean isLeaf = false;
        for (WebElement element : this.getItems()) {
            if (!element.getAttribute("data-label").equalsIgnoreCase(label)) continue;
            isLeaf = !PrimeSelenium.hasCssClass((WebElement)element, (String[])new String[]{"ui-cascadeselect-item-group"});
            this.click(element);
            break;
        }
    }

    public String getSelectedLabel() {
        return this.getLabel().getText();
    }

    public boolean isSelected(String label) {
        boolean result = false;
        try {
            result = this.getSelectedLabel().equalsIgnoreCase(label);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<String> getLabels() {
        return this.getItems().stream().map(e -> e.getAttribute("data-label")).collect(Collectors.toList());
    }

    public List<String> getValues() {
        return this.getItems().stream().map(e -> e.getAttribute("data-value")).collect(Collectors.toList());
    }

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getLabel() {
        return this.findElement(By.className((String)"ui-cascadeselect-label"));
    }

    public List<WebElement> getItems() {
        return this.getPanel().findElements(By.className((String)"ui-cascadeselect-item"));
    }

    public List<WebElement> getLeafItems() {
        return this.getItems().stream().filter(i -> !PrimeSelenium.hasCssClass((WebElement)i, (String[])new String[]{"ui-cascadeselect-item-group"})).collect(Collectors.toList());
    }

    public WebElement getPanel() {
        return this.panel;
    }

    protected void click(WebElement element) {
        if (!PrimeSelenium.hasCssClass((WebElement)element, (String[])new String[]{"ui-cascadeselect-item-group"}) && (this.isOnchangeAjaxified() || this.isItemSelectAjaxified())) {
            ((WebElement)PrimeSelenium.guardAjax((Object)element)).click();
        } else {
            element.click();
        }
    }
}

