/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractInputComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.findby.FindByParentPartialId;

public abstract class DatePicker
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    public void click() {
        this.input.click();
        PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.getPanel()));
    }

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getPanel() {
        return this.getWebDriver().findElement(By.id((String)(this.getId() + "_panel")));
    }

    public boolean isDateSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "dateSelect");
    }

    public boolean isViewChangeAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "viewChange");
    }

    public boolean isCloseAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "close");
    }

    public WebElement getNextMonthLink() {
        WebElement link = this.showPanel().findElement(By.className((String)"ui-datepicker-next"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if (this.isViewChangeAjaxified()) {
            link = (WebElement)PrimeSelenium.guardAjax((Object)link);
        }
        return link;
    }

    public WebElement getPreviousMonthLink() {
        WebElement link = this.showPanel().findElement(By.className((String)"ui-datepicker-prev"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if (this.isViewChangeAjaxified()) {
            link = (WebElement)PrimeSelenium.guardAjax((Object)link);
        }
        return link;
    }

    public WebElement selectDay(String day) {
        WebElement link = this.showPanel().findElement(By.linkText((String)day));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if (this.isDateSelectAjaxified()) {
            link = (WebElement)PrimeSelenium.guardAjax((Object)link);
        }
        link.click();
        return link;
    }

    public WebElement getClearButton() {
        WebElement button = this.showPanel().findElement(By.className((String)"ui-datepicker-buttonbar")).findElement(By.className((String)"ui-clear-button"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)button));
        return button;
    }

    public WebElement getTodayButton() {
        WebElement button = this.showPanel().findElement(By.className((String)"ui-datepicker-buttonbar")).findElement(By.className((String)"ui-today-button"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)button));
        return button;
    }

    public LocalDateTime getValue() {
        if (this.getWidgetDate() == null) {
            return null;
        }
        String utcTimeString = (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().toUTCString();"), (Object[])new Object[0]);
        LocalDateTime dateTime = LocalDateTime.parse(utcTimeString, DateTimeFormatter.RFC_1123_DATE_TIME);
        dateTime = LocalDateTime.ofInstant(dateTime.toInstant(ZoneOffset.UTC), ZoneId.systemDefault());
        return dateTime;
    }

    public LocalDate getValueAsLocalDate() {
        if (this.getWidgetDate() == null) {
            return null;
        }
        Long dayOfMonth = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getDate();"), (Object[])new Object[0]);
        Long month = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getMonth();"), (Object[])new Object[0]);
        Long year = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getFullYear();"), (Object[])new Object[0]);
        return LocalDate.of(year.intValue(), month.intValue() + 1, dayOfMonth.intValue());
    }

    public void setValue(LocalDate localDate) {
        this.setValue(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public void setValue(LocalDateTime dateTime) {
        long millis = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.setValue(millis);
    }

    public void setValue(long millis) {
        this.setDate(millis);
    }

    public String millisAsFormattedDate(long millis) {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".jq.data().primeDatePicker.formatDateTime(new Date(" + millis + "));"), (Object[])new Object[0]);
    }

    public void setDate(LocalDateTime dateTime) {
        long millis = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.setDate(millis);
    }

    public void setDate(long epoch) {
        PrimeSelenium.executeScript((boolean)this.isDateSelectAjaxified(), (String)(this.getWidgetByIdScript() + ".setDate(new Date(" + epoch + "));"), (Object[])new Object[0]);
    }

    public String getWidgetDate() {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate();"), (Object[])new Object[0]);
    }

    public void updateViewDate(long epoch) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".jq.data().primeDatePicker.updateViewDate(null, new Date(" + epoch + "));"), (Object[])new Object[0]);
    }

    public WebElement showPanel() {
        if (this.isEnabled()) {
            PrimeSelenium.wait((int)110);
            if (!this.getPanel().isDisplayed()) {
                PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show()"), (Object[])new Object[0]);
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.getPanel()));
        }
        return this.getPanel();
    }

    public void hidePanel() {
        if (this.isEnabled()) {
            if (this.getPanel().isDisplayed()) {
                PrimeSelenium.executeScript((boolean)this.isCloseAjaxified(), (String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
                PrimeSelenium.wait((int)110);
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)this.getPanel()));
        }
    }

    public void disable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable();"), (Object[])new Object[0]);
    }

    public void enable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable();"), (Object[])new Object[0]);
    }

    public long getTimezoneOffset() {
        return (Long)PrimeSelenium.executeScript((String)"return new Date().getTimezoneOffset();", (Object[])new Object[0]);
    }
}

