/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractInputComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.findby.FindByParentPartialId;

public abstract class Rating
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public boolean isCancelAjaxified() {
        return ComponentUtils.hasBehavior((WebElement)this, "cancel") || this.isOnchangeAjaxified();
    }

    public boolean isRatingAjaxified() {
        return ComponentUtils.hasBehavior((WebElement)this, "rate") || this.isOnchangeAjaxified();
    }

    public WebElement getCancelIcon() {
        return this.findElement(By.className((String)"ui-rating-cancel"));
    }

    public void cancel() {
        WebElement cancelIcon = this.getCancelIcon();
        if (this.isCancelAjaxified() || this.isRatingAjaxified()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)cancelIcon)).click();
        } else {
            cancelIcon.click();
        }
    }

    public Number getValue() {
        return (Number)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getValue();"), (Object[])new Object[0]);
    }

    public void setValue(Number value) {
        PrimeSelenium.executeScript((boolean)this.isRatingAjaxified(), (String)(this.getWidgetByIdScript() + ".setValue(" + value + ");"), (Object[])new Object[0]);
    }

    public void enable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable();"), (Object[])new Object[0]);
    }

    public void disable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable();"), (Object[])new Object[0]);
    }

    public void reset() {
        PrimeSelenium.executeScript((boolean)this.isCancelAjaxified(), (String)(this.getWidgetByIdScript() + ".reset();"), (Object[])new Object[0]);
    }

    public boolean isDisabled() {
        return (Boolean)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".isDisabled();"), (Object[])new Object[0]);
    }

    public boolean isReadOnly() {
        return (Boolean)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".isReadOnly();"), (Object[])new Object[0]);
    }

    @Override
    public boolean isEnabled() {
        return !this.isDisabled();
    }
}

