/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractInputComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.findby.FindByParentPartialId;

public abstract class SelectOneMenu
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindByParentPartialId(value="_panel", searchFromRoot=true)
    private WebElement panel;

    public boolean isItemSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemSelect");
    }

    public void toggleDropdown() {
        if (this.getPanel().isDisplayed()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public void show() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && !panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void hide() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void enable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable();"), (Object[])new Object[0]);
    }

    public void disable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable();"), (Object[])new Object[0]);
    }

    public void deselect(String label) {
        if (!this.isSelected(label) || !this.isEnabled()) {
            return;
        }
        if (!this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
        for (WebElement element : this.getItems().findElements(By.tagName((String)"li"))) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            this.click(element);
            break;
        }
        if (this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
    }

    public void select(String label) {
        if (this.isSelected(label) || !this.isEnabled()) {
            return;
        }
        if (!this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
        for (WebElement element : this.getItems().findElements(By.tagName((String)"li"))) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            this.click(element);
            break;
        }
        if (this.getPanel().isDisplayed()) {
            this.toggleDropdown();
        }
    }

    public String getSelectedLabel() {
        return this.getLabel().getText();
    }

    public boolean isSelected(String label) {
        boolean result = false;
        try {
            result = this.getSelectedLabel().equalsIgnoreCase(label);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<String> getLabels() {
        return this.getInput().findElements(By.tagName((String)"option")).stream().map(e -> e.getAttribute("innerHTML")).collect(Collectors.toList());
    }

    public void select(int index) {
        if (this.isSelected(index)) {
            return;
        }
        this.select(this.getLabel(index));
    }

    public void deselect(int index) {
        if (!this.isSelected(index)) {
            return;
        }
        this.deselect(this.getLabel(index));
    }

    public boolean isSelected(int index) {
        return this.getLabel(index).equals(this.getSelectedLabel());
    }

    public String getLabel(int index) {
        return this.getLabels().get(index);
    }

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getEditableInput() {
        return this.getRoot().findElement(By.name((String)(this.getId() + "_editableInput")));
    }

    public WebElement getLabel() {
        return this.getRoot().findElement(By.id((String)(this.getId() + "_label")));
    }

    public WebElement getItems() {
        return this.getWebDriver().findElement(By.id((String)(this.getId() + "_items")));
    }

    public WebElement getPanel() {
        return this.panel;
    }

    protected void click(WebElement element) {
        if (this.isOnchangeAjaxified() || this.isItemSelectAjaxified()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)element)).click();
        } else {
            element.click();
        }
    }
}

