/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractComponent;
import org.primefaces.extensions.selenium.component.model.SelectItem;

public abstract class SelectOneRadio
extends AbstractComponent {
    @FindBy(css=".ui-radiobutton")
    private List<WebElement> radioButtons;

    public List<WebElement> getRadioButtons() {
        return this.radioButtons;
    }

    public WebElement getRadioButton(int index) {
        WebElement radiobutton = this.getRadioButtons().get(index);
        PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)radiobutton));
        return radiobutton;
    }

    public WebElement getRadioButtonBox(int index) {
        WebElement radiobutton = this.getRadioButton(index);
        return radiobutton.findElement(By.className((String)"ui-radiobutton-box"));
    }

    public void select(int index) {
        if (!this.getWidgetConfiguration().getBoolean("unselectable") && this.getSelectedIndex() == index) {
            return;
        }
        WebElement radiobutton = this.getRadioButton(index);
        WebElement box = radiobutton.findElement(By.className((String)"ui-radiobutton-box"));
        WebElement input = radiobutton.findElement(By.tagName((String)"input"));
        if (this.isAjaxified(input, "onchange")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)box)).click();
        } else {
            box.click();
        }
    }

    public void select(String text) {
        int indexToSelect = this.getLabels().indexOf(text);
        if (indexToSelect >= 0) {
            this.select(indexToSelect);
        }
    }

    public int getSelectedIndex() {
        for (SelectItem item : this.getItems()) {
            if (!item.isSelected()) continue;
            return item.getIndex();
        }
        return -1;
    }

    public String getSelectedLabel() {
        for (SelectItem item : this.getItems()) {
            if (!item.isSelected()) continue;
            return item.getLabel();
        }
        return "";
    }

    public List<String> getLabels() {
        return this.getItems().stream().map(SelectItem::getLabel).collect(Collectors.toList());
    }

    public String getLabel(int index) {
        return this.getItems().get(index).getLabel();
    }

    public int getItemsSize() {
        return this.getRadioButtons().size();
    }

    public List<SelectItem> getItems() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        int idx = 0;
        for (WebElement radiobutton : this.getRadioButtons()) {
            WebElement input = radiobutton.findElement(By.tagName((String)"input"));
            WebElement label = this.getRoot().findElement(By.cssSelector((String)("label[for='" + input.getAttribute("id") + "']")));
            WebElement box = radiobutton.findElement(By.className((String)"ui-radiobutton-box"));
            SelectItem item = new SelectItem();
            item.setIndex(idx);
            item.setLabel(label.getText());
            item.setValue(input.getAttribute("value"));
            item.setSelected(PrimeSelenium.hasCssClass((WebElement)box, (String[])new String[]{"ui-state-active"}));
            items.add(item);
            ++idx;
        }
        return items;
    }

    public void disable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable();"), (Object[])new Object[0]);
    }

    public void enable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable();"), (Object[])new Object[0]);
    }

    public void disableOption(int index) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable(" + index + ");"), (Object[])new Object[0]);
    }

    public void enableOption(int index) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable(" + index + ");"), (Object[])new Object[0]);
    }
}

