/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;

public abstract class Timeline
extends AbstractComponent {
    public void select(String cssClass) {
        WebElement element = this.findElement(By.className((String)cssClass));
        if (this.isSelectAjaxified()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)element)).click();
        } else {
            element.click();
        }
    }

    public boolean isRangeChangedAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "rangechanged");
    }

    public boolean isSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "select");
    }

    public void update() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".renderTimeline();"), (Object[])new Object[0]);
    }

    public long getNumberOfEvents() {
        return (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getNumberOfEvents();"), (Object[])new Object[0]);
    }

    public void zoom(double zoomFactor) {
        PrimeSelenium.executeScript((boolean)this.isRangeChangedAjaxified(), (String)(this.getWidgetByIdScript() + ".zoom(" + zoomFactor + ");"), (Object[])new Object[0]);
    }

    public void move(double moveFactor) {
        PrimeSelenium.executeScript((boolean)this.isRangeChangedAjaxified(), (String)(this.getWidgetByIdScript() + ".move(" + moveFactor + ");"), (Object[])new Object[0]);
    }
}

