/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component.base;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.AbstractComponent;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;

public abstract class AbstractInputComponent
extends AbstractComponent {
    public WebElement getInput() {
        return this.getRoot();
    }

    public boolean isEnabled() {
        return this.getInput().isEnabled() && !PrimeSelenium.hasCssClass((WebElement)this, (String[])new String[]{"ui-state-disabled"});
    }

    public boolean isOnchangeAjaxified() {
        return this.isAjaxified(this.getInput(), "onchange") || ComponentUtils.hasAjaxBehavior(this.getRoot(), "change");
    }

    public WebElement getAssignedLabel() {
        return this.getWebDriver().findElement(By.cssSelector((String)("label[for='" + this.getInput().getAttribute("id") + "']")));
    }

    public String getAssignedLabelText() {
        return this.getAssignedLabel().getText();
    }

    public String copyToClipboard() {
        WebElement input = this.getInput();
        Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "c"})});
        return input.getAttribute("value");
    }

    public String pasteFromClipboard() {
        WebElement input = this.getInput();
        Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "v"})});
        return input.getAttribute("value");
    }

    public void selectAllText() {
        Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
        this.getInput().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
    }

    public void clear() {
        PrimeSelenium.clearInput((WebElement)this.getInput(), (boolean)false);
    }
}

