/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component.model.data;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.model.data.Page;

public class Paginator {
    private WebElement webElement;
    private List<Page> pages;

    public Paginator(WebElement webElement) {
        this.webElement = webElement;
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public List<Page> getPages() {
        if (this.pages == null) {
            this.pages = this.webElement.findElements(By.className((String)"ui-paginator-page")).stream().map(pageElt -> {
                int number = Integer.parseInt(pageElt.getText());
                return new Page(number, (WebElement)pageElt);
            }).collect(Collectors.toList());
        }
        return this.pages;
    }

    public Page getPage(int index) {
        return this.getPages().get(index);
    }

    public Page getActivePage() {
        List<Page> pages = this.getPages();
        for (Page page : pages) {
            if (!PrimeSelenium.hasCssClass((WebElement)page.getWebElement(), (String[])new String[]{"ui-state-active"})) continue;
            return page;
        }
        return null;
    }
}

