/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.selenium.component.model.datatable;

import java.util.Locale;
import java.util.function.Function;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.selenium.PrimeExpectedConditions;
import org.primefaces.extensions.selenium.PrimeSelenium;
import org.primefaces.extensions.selenium.component.base.ComponentUtils;
import org.primefaces.extensions.selenium.component.model.datatable.Cell;

public class HeaderCell
extends Cell {
    public HeaderCell(WebElement webElement) {
        super(webElement);
    }

    public WebElement getColumnTitle() {
        if (this.getWebElement() != null) {
            return this.getWebElement().findElement(By.className((String)"ui-column-title"));
        }
        return null;
    }

    public WebElement getColumnFilter() {
        if (this.getWebElement() != null) {
            return this.getWebElement().findElement(By.className((String)"ui-column-filter"));
        }
        return null;
    }

    public void setFilterValue(JSONObject cfg, String filterValue) {
        String filterEvent = cfg.getString("filterEvent");
        int filterDelay = cfg.getInt("filterDelay");
        this.setFilterValue(filterValue, filterEvent, filterDelay);
    }

    public void setFilterValue(String filterValue, String filterEvent, int filterDelay) {
        WebElement columnFilter;
        try {
            columnFilter = this.getColumnFilter();
        }
        catch (NoSuchElementException ex) {
            columnFilter = this.getWebElement().findElement(By.tagName((String)"input"));
        }
        columnFilter.clear();
        Keys triggerKey = null;
        switch (filterEvent = filterEvent.toLowerCase(Locale.ROOT)) {
            case "keyup": 
            case "keydown": 
            case "keypress": 
            case "input": {
                if (filterDelay != 0) break;
                columnFilter = (WebElement)PrimeSelenium.guardAjax((Object)columnFilter);
                break;
            }
            case "enter": {
                triggerKey = Keys.ENTER;
                break;
            }
            case "change": 
            case "blur": {
                triggerKey = Keys.TAB;
                break;
            }
        }
        if (filterValue != null) {
            ComponentUtils.sendKeys(columnFilter, filterValue);
        } else {
            columnFilter.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
        if (triggerKey != null) {
            ((WebElement)PrimeSelenium.guardAjax((Object)columnFilter)).sendKeys(new CharSequence[]{triggerKey});
        } else if (filterDelay > 0) {
            try {
                Thread.sleep(filterDelay * 2);
            }
            catch (InterruptedException ex) {
                System.err.println("AJAX Guard delay was interrupted!");
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.animationNotActive());
        }
    }

    public String toString() {
        return "HeaderCell{text=" + this.getColumnTitle().getText() + "}";
    }
}

