/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.ckeditor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class ResourceModifier {
    private static final String PROJECT_DIRECTORY = System.getProperty("user.dir");
    private static final String SHORT_HASH = "K5I7";
    private static final int INDEX_NOT_FOUND = -1;

    public static void main(String[] args) throws IOException {
        String resourcesDirectory = PROJECT_DIRECTORY + "/src/main/resources/META-INF/resources/primefaces-extensions/";
        System.err.println("######## Modify skin styles...." + resourcesDirectory);
        File skinsPath = new File(PROJECT_DIRECTORY + "/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/skins/");
        for (String skin : Objects.requireNonNull(skinsPath.list())) {
            System.err.println("#### Modify skin '" + skin + "'");
            File skinDirectory = new File(resourcesDirectory + "ckeditor/skins/" + skin);
            String relativeSkinPath = ResourceModifier.replace(ResourceModifier.replace(skinDirectory.getPath(), resourcesDirectory, ""), "\\", "/");
            for (File resourceToModify : Objects.requireNonNull(skinDirectory.listFiles())) {
                if (!resourceToModify.getName().endsWith(".css")) continue;
                System.err.println("## Modify file '" + resourceToModify.getName() + "'");
                String fileContent = FileUtils.readFileToString((File)resourceToModify, (Charset)Charset.defaultCharset());
                List<File> allSkinResources = ResourceModifier.getResourcesList(skinDirectory);
                for (File resource : allSkinResources) {
                    if (resource.getName().endsWith(".css")) continue;
                    String relativeResourcePath = ResourceModifier.replace(ResourceModifier.replace(resource.getPath(), resourcesDirectory, ""), "\\", "/");
                    String resourceName = ResourceModifier.replace(resource.getAbsolutePath().replace(skinDirectory.getAbsolutePath(), ""), "\\", "/");
                    if (resourceName.startsWith("/")) {
                        resourceName = resourceName.substring(1);
                    }
                    fileContent = fileContent.replaceAll("url\\(" + resourceName + "\\)", "url\\(\"#{resource['primefaces-extensions:" + relativeResourcePath + "']}\"\\)");
                }
                fileContent = fileContent.replaceAll("url\\(icons.png\\?t=K5I7", "url\\(\"#{resource['primefaces-extensions:" + relativeSkinPath + "/icons.png']}&t=" + SHORT_HASH + "\"");
                fileContent = fileContent.replaceAll("url\\(icons_hidpi.png\\?t=K5I7", "url\\(\"#{resource['primefaces-extensions:" + relativeSkinPath + "/icons_hidpi.png']}&t=" + SHORT_HASH + "\"");
                FileUtils.writeStringToFile((File)resourceToModify, (String)fileContent, (Charset)Charset.defaultCharset());
            }
            File file = new File(PROJECT_DIRECTORY + "/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/plugins/smiley/dialogs/smiley.js");
            String fileContent = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()).replaceAll("CKEDITOR.tools.htmlEncode\\(e\\.smiley_path\\+h\\[a\\]\\)", "CKEDITOR.tools.htmlEncode\\(CKEDITOR.getUrl\\(e\\.smiley_path\\+h\\[a\\]\\)\\)");
            FileUtils.writeStringToFile((File)file, (String)fileContent, (Charset)Charset.defaultCharset());
        }
        File file = new File(resourcesDirectory + "ckeditor/ckeditor.js");
        String fileContent = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        fileContent = fileContent.replaceAll("this.path\\+\"styles/copyformatting.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/copyformatting.css\")");
        fileContent = fileContent.replaceAll("this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/scayt.css\"", "CKEDITOR.getUrl(this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/scayt.css\")");
        fileContent = fileContent.replaceAll("this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/wsc.css\"", "CKEDITOR.getUrl(this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/wsc.css\")");
        fileContent = fileContent.replaceAll("this.path\\+\"styles/dialog.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/dialog.css\")");
        fileContent = fileContent.replaceAll("this.path\\+\"styles/tableselection.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/tableselection.css\")");
        fileContent = fileContent.replaceAll("CKEDITOR.plugins.get\\(\"mathjax\"\\).path\\+\"images/loader.gif\"", "CKEDITOR.getUrl(CKEDITOR.plugins.get\\(\"mathjax\"\\).path\\+\"images/loader.gif\")");
        fileContent = fileContent.replaceAll("b.plugins.widget.path\\+\"images/handle.png", "CKEDITOR.getUrl(b.plugins.widget.path\\+\"images/handle.png\")\\+\"");
        FileUtils.writeStringToFile((File)file, (String)fileContent, (Charset)Charset.defaultCharset());
    }

    private static List<File> getResourcesList(File file) {
        String name = file.getName();
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                result.addAll(ResourceModifier.getResourcesList(f));
            }
        } else if (name.endsWith(".png") || name.endsWith(".css")) {
            result.add(file);
        }
        return result;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return seq.toString().indexOf(searchSeq.toString(), startPos);
    }

    public static String replace(String text, String searchString, String replacement) {
        if (ResourceModifier.isEmpty(text) || ResourceModifier.isEmpty(searchString) || replacement == null) {
            return text;
        }
        int max = -1;
        int start = 0;
        int end = ResourceModifier.indexOf(text, searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = Math.max(increase, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = ResourceModifier.indexOf(text, searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

