
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Configuration options for editor scrollbars
 */
@SuppressWarnings("serial")
public class EditorScrollbarOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorScrollbarOptions(this);
    }

    private static class SerializedEditorScrollbarOptions implements Serializable {
        private String json;

        public SerializedEditorScrollbarOptions(EditorScrollbarOptions editorScrollbarOptions) {
            this.json = editorScrollbarOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorScrollbarOptions editorScrollbarOptions = new EditorScrollbarOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorScrollbarOptions.put(key, value);
            }
            return editorScrollbarOptions;
        }
    }

    /**
     * @return Always consume mouse wheel events (always call {@code preventDefault()} and {@code stopPropagation()} on
     * the browser events). Defaults to {@code true}.
     */
    public Boolean isAlwaysConsumeMouseWheel() {
        return (Boolean) (has("alwaysConsumeMouseWheel") ? get("alwaysConsumeMouseWheel") : null);
    }

    /**
     * @param alwaysConsumeMouseWheel Always consume mouse wheel events (always call {@code preventDefault()} and {@code
     * stopPropagation()} on the browser events). Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setAlwaysConsumeMouseWheel(final Boolean alwaysConsumeMouseWheel) {
        put("alwaysConsumeMouseWheel", alwaysConsumeMouseWheel);
        return this;
    }

    /**
     * @return The size of arrows (if displayed). Defaults to {@code 11}.
     */
    public Number getArrowSize() {
        return (Number) (has("arrowSize") ? get("arrowSize") : null);
    }

    /**
     * @param arrowSize The size of arrows (if displayed). Defaults to {@code 11}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setArrowSize(final Number arrowSize) {
        put("arrowSize", arrowSize);
        return this;
    }

    /**
     * @return Listen to mouse wheel events and react to them by scrolling. Defaults to {@code true}.
     */
    public Boolean isHandleMouseWheel() {
        return (Boolean) (has("handleMouseWheel") ? get("handleMouseWheel") : null);
    }

    /**
     * @param handleMouseWheel Listen to mouse wheel events and react to them by scrolling. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setHandleMouseWheel(final Boolean handleMouseWheel) {
        put("handleMouseWheel", handleMouseWheel);
        return this;
    }

    /**
     * @return Render horizontal scrollbar. Defaults to {@code auto}.
     */
    public String getHorizontal() {
        return (String) (has("horizontal") ? get("horizontal") : null);
    }

    /**
     * @param horizontal Render horizontal scrollbar. Defaults to {@code auto}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setHorizontal(final EScrollbarHorizontal horizontal) {
        put("horizontal", horizontal != null ? horizontal.toString() : null);
        return this;
    }

    /**
     * @param horizontal Render horizontal scrollbar. Defaults to {@code auto}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setHorizontal(final String horizontal) {
        put("horizontal", horizontal);
        return this;
    }

    /**
     * @return Render arrows at the left and right of the horizontal scrollbar. Defaults to {@code false}.
     */
    public Boolean isHorizontalHasArrows() {
        return (Boolean) (has("horizontalHasArrows") ? get("horizontalHasArrows") : null);
    }

    /**
     * @param horizontalHasArrows Render arrows at the left and right of the horizontal scrollbar. Defaults to {@code
     * false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setHorizontalHasArrows(final Boolean horizontalHasArrows) {
        put("horizontalHasArrows", horizontalHasArrows);
        return this;
    }

    /**
     * @return Height in pixels for the horizontal scrollbar. Defaults to {@code 10} (px).
     */
    public Number getHorizontalScrollbarSize() {
        return (Number) (has("horizontalScrollbarSize") ? get("horizontalScrollbarSize") : null);
    }

    /**
     * @param horizontalScrollbarSize Height in pixels for the horizontal scrollbar. Defaults to {@code 10} (px).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setHorizontalScrollbarSize(final Number horizontalScrollbarSize) {
        put("horizontalScrollbarSize", horizontalScrollbarSize);
        return this;
    }

    /**
     * @return Height in pixels for the horizontal slider. Defaults to {@code horizontalScrollbarSize}.
     */
    public Number getHorizontalSliderSize() {
        return (Number) (has("horizontalSliderSize") ? get("horizontalSliderSize") : null);
    }

    /**
     * @param horizontalSliderSize Height in pixels for the horizontal slider. Defaults to {@code
     * horizontalScrollbarSize}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setHorizontalSliderSize(final Number horizontalSliderSize) {
        put("horizontalSliderSize", horizontalSliderSize);
        return this;
    }

    /**
     * @return Scroll gutter clicks move by page vs jump to position. Defaults to {@code false}.
     */
    public Boolean isScrollByPage() {
        return (Boolean) (has("scrollByPage") ? get("scrollByPage") : null);
    }

    /**
     * @param scrollByPage Scroll gutter clicks move by page vs jump to position. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setScrollByPage(final Boolean scrollByPage) {
        put("scrollByPage", scrollByPage);
        return this;
    }

    /**
     * @return Cast horizontal and vertical shadows when the content is scrolled. Defaults to {@code true}.
     */
    public Boolean isUseShadows() {
        return (Boolean) (has("useShadows") ? get("useShadows") : null);
    }

    /**
     * @param useShadows Cast horizontal and vertical shadows when the content is scrolled. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setUseShadows(final Boolean useShadows) {
        put("useShadows", useShadows);
        return this;
    }

    /**
     * @return Render vertical scrollbar. Defaults to {@code auto}.
     */
    public String getVertical() {
        return (String) (has("vertical") ? get("vertical") : null);
    }

    /**
     * @param vertical Render vertical scrollbar. Defaults to {@code auto}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setVertical(final EScrollbarVertical vertical) {
        put("vertical", vertical != null ? vertical.toString() : null);
        return this;
    }

    /**
     * @param vertical Render vertical scrollbar. Defaults to {@code auto}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setVertical(final String vertical) {
        put("vertical", vertical);
        return this;
    }

    /**
     * @return Render arrows at the top and bottom of the vertical scrollbar. Defaults to {@code false}.
     */
    public Boolean isVerticalHasArrows() {
        return (Boolean) (has("verticalHasArrows") ? get("verticalHasArrows") : null);
    }

    /**
     * @param verticalHasArrows Render arrows at the top and bottom of the vertical scrollbar. Defaults to {@code
     * false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setVerticalHasArrows(final Boolean verticalHasArrows) {
        put("verticalHasArrows", verticalHasArrows);
        return this;
    }

    /**
     * @return Width in pixels for the vertical scrollbar. Defaults to {@code 10} (px).
     */
    public Number getVerticalScrollbarSize() {
        return (Number) (has("verticalScrollbarSize") ? get("verticalScrollbarSize") : null);
    }

    /**
     * @param verticalScrollbarSize Width in pixels for the vertical scrollbar. Defaults to {@code 10} (px).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setVerticalScrollbarSize(final Number verticalScrollbarSize) {
        put("verticalScrollbarSize", verticalScrollbarSize);
        return this;
    }

    /**
     * @return Width in pixels for the vertical slider. Defaults to {@code verticalScrollbarSize}.
     */
    public Number getVerticalSliderSize() {
        return (Number) (has("verticalSliderSize") ? get("verticalSliderSize") : null);
    }

    /**
     * @param verticalSliderSize Width in pixels for the vertical slider. Defaults to {@code verticalScrollbarSize}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorScrollbarOptions setVerticalSliderSize(final Number verticalSliderSize) {
        put("verticalSliderSize", verticalSliderSize);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}