
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Defines how Unicode characters should be highlighted.
 */
@SuppressWarnings("serial")
public class EditorUnicodeHighlightOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorUnicodeHighlightOptions(this);
    }

    private static class SerializedEditorUnicodeHighlightOptions implements Serializable {
        private String json;

        public SerializedEditorUnicodeHighlightOptions(EditorUnicodeHighlightOptions editorUnicodeHighlightOptions) {
            this.json = editorUnicodeHighlightOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorUnicodeHighlightOptions editorUnicodeHighlightOptions = new EditorUnicodeHighlightOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorUnicodeHighlightOptions.put(key, value);
            }
            return editorUnicodeHighlightOptions;
        }
    }

    /**
     * @return A map of allowed characters ({@code true}: allowed).
     */
    public JSONObject getAllowedCharacters() {
        return (JSONObject) (has("allowedCharacters") ? get("allowedCharacters") : null);
    }

    /**
     * @param allowedCharacters A map of allowed characters ({@code true}: allowed).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAllowedCharacters(final JSONObject allowedCharacters) {
        put("allowedCharacters", allowedCharacters);
        return this;
    }

    /**
     * A map of allowed characters ({@code true}: allowed).
     * @param key The key of the map entry to add.
     * @param value The value to associate with the key.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions addAllowedCharacter(final String key, final Boolean value) {
        JSONObject x = getAllowedCharacters();
        if (x == null) {
            x = new JSONObject();
            setAllowedCharacters(x);
        }
        x.put(key, value);
        return this;
    }

    /**
     * @param allowedCharacters A map of allowed characters ({@code true}: allowed).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAllowedCharacters(final java.util.Map<String, Boolean> allowedCharacters) {
        return setAllowedCharacters(new JSONObject(allowedCharacters));
    }

    public Boolean isAmbiguousCharacters() {
        return (Boolean) (has("ambiguousCharacters") ? get("ambiguousCharacters") : null);
    }

    public EditorUnicodeHighlightOptions setAmbiguousCharacters(final Boolean ambiguousCharacters) {
        put("ambiguousCharacters", ambiguousCharacters);
        return this;
    }

    public Boolean isIncludeComments() {
        return (Boolean) (has("includeComments") ? get("includeComments") : null);
    }

    public EditorUnicodeHighlightOptions setIncludeComments(final Boolean includeComments) {
        put("includeComments", includeComments);
        return this;
    }

    public Boolean isInvisibleCharacters() {
        return (Boolean) (has("invisibleCharacters") ? get("invisibleCharacters") : null);
    }

    public EditorUnicodeHighlightOptions setInvisibleCharacters(final Boolean invisibleCharacters) {
        put("invisibleCharacters", invisibleCharacters);
        return this;
    }

    public Boolean isNonBasicASCII() {
        return (Boolean) (has("nonBasicASCII") ? get("nonBasicASCII") : null);
    }

    public EditorUnicodeHighlightOptions setNonBasicASCII(final Boolean nonBasicASCII) {
        put("nonBasicASCII", nonBasicASCII);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}