/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.util;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class ResourcesScanner {
    public static final String CSS_FILE_EXTENSION = "css";
    public static final String JS_FILE_EXTENSION = "js";
    private final Set<File> jsFiles = new LinkedHashSet<File>();
    private final Set<File> cssFiles = new LinkedHashSet<File>();

    public Set<File> getJsFiles() {
        return this.jsFiles;
    }

    public Set<File> getCssFiles() {
        return this.cssFiles;
    }

    public void scan(File inputDir, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            if (inputDir.isFile()) {
                throw new MojoExecutionException("Config parameter 'inputDir' is wrong. " + inputDir.getAbsolutePath() + " is not a directory");
            }
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(inputDir);
            directoryScanner.setExcludes(excludes);
            for (String include : includes) {
                directoryScanner.setIncludes(new String[]{include});
                directoryScanner.scan();
                Object[] fileNames = directoryScanner.getIncludedFiles();
                if (fileNames.length > 1) {
                    Arrays.sort(fileNames);
                }
                for (Object fileName : fileNames) {
                    String extension = FileUtils.extension((String)fileName);
                    if (CSS_FILE_EXTENSION.equalsIgnoreCase(extension)) {
                        this.cssFiles.add(new File(inputDir, (String)fileName));
                        continue;
                    }
                    if (!JS_FILE_EXTENSION.equalsIgnoreCase(extension)) continue;
                    this.jsFiles.add(new File(inputDir, (String)fileName));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while scanning resources files under the input directory '" + inputDir + "'", e);
        }
    }
}

