/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.replacer;

import com.google.common.primitives.Chars;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.primefaces.extensions.optimizerplugin.replacer.AbstractTokenReplacingReader;
import org.primefaces.extensions.optimizerplugin.replacer.TokenResolver;

public class CSSRelativeURLReplacingReader
extends AbstractTokenReplacingReader {
    private static final char[] URL_FUNC_CALL_START = "url(".toCharArray();
    private static final int URL_FUNC_CALL_START_LEN = URL_FUNC_CALL_START.length;
    private static final List<char[]> IGNORED_ARGUMENT_PREFIXES = List.of("https:", "http:", "blob:", "#", "data:").stream().map(String::toCharArray).collect(Collectors.toUnmodifiableList());
    private static final char[] TRIM_ARGUMENTS_CHARS = "\t'\"".toCharArray();
    private final char[] startChars = new char[20];
    private int argStart;

    public CSSRelativeURLReplacingReader(Log log, TokenResolver tokenResolver, Reader source) {
        super(log, tokenResolver, source, 20);
    }

    @Override
    protected boolean matchTokenStart() throws IOException {
        int countValidChars = this.readChars(this.startChars);
        if (countValidChars == -1) {
            return false;
        }
        if (this.startChars[0] != ' ' && this.startChars[0] != '\t' && this.startChars[0] != ':' && this.startChars[0] != '\"') {
            this.pushbackReader.unread(this.startChars, 0, countValidChars);
            return false;
        }
        if (!Arrays.equals(URL_FUNC_CALL_START, 0, URL_FUNC_CALL_START_LEN, this.startChars, 1, URL_FUNC_CALL_START_LEN + 1)) {
            this.pushbackReader.unread(this.startChars, 0, countValidChars);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Found CSS url function call: " + String.valueOf(this.startChars)));
        }
        this.argStart = URL_FUNC_CALL_START_LEN + 1;
        while (Chars.contains((char[])TRIM_ARGUMENTS_CHARS, (char)this.startChars[this.argStart])) {
            ++this.argStart;
            if (this.argStart != this.startChars.length) continue;
            this.pushbackReader.unread(this.startChars, 0, countValidChars);
            return false;
        }
        for (char[] prefix : IGNORED_ARGUMENT_PREFIXES) {
            if (this.argStart + prefix.length > this.startChars.length || !Arrays.equals(prefix, 0, prefix.length, this.startChars, this.argStart, this.argStart + prefix.length)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Matched ignored argument prefix: " + String.valueOf(prefix)));
            }
            this.pushbackReader.unread(this.startChars, 0, countValidChars);
            return false;
        }
        if (Chars.contains((char[])this.startChars, (char)'#')) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Matched ignored SVG fragment argument");
            }
            this.pushbackReader.unread(this.startChars, 0, countValidChars);
            return false;
        }
        this.pushbackReader.unread(this.startChars, this.argStart, this.startChars.length - this.argStart);
        return true;
    }

    @Override
    protected boolean findToken() throws IOException {
        boolean cancel = false;
        this.tokenBuffer.setLength(0);
        int ch = this.pushbackReader.read();
        while (ch != 41) {
            if (ch == -1 || ch == 35) {
                cancel = true;
                break;
            }
            this.tokenBuffer.append((char)ch);
            ch = this.pushbackReader.read();
        }
        if (cancel) {
            this.resolvedToken = String.valueOf(this.startChars, 0, this.argStart) + this.tokenBuffer;
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Extracted CSS url() relative URL argument to resolve: " + this.tokenBuffer));
        }
        return true;
    }

    @Override
    protected void handleResolverResult() {
        this.resolvedToken = this.resolvedToken != null ? String.valueOf(this.startChars, 0, URL_FUNC_CALL_START_LEN + 1) + this.resolvedToken + ")" : String.valueOf(this.startChars, 0, this.argStart) + this.tokenBuffer + ")";
    }
}

