/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.common;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.integrationtests.common.VariableMapperWrapper;

public class IncludesTagHandler
extends TagHandler {
    private TagAttribute src = this.getRequiredAttribute("src");
    private TagAttribute value = this.getAttribute("value");
    private TagAttribute name = this.getAttribute("name");

    public IncludesTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String path = this.src.getValue(ctx);
        if (path == null || path.length() == 0) {
            return;
        }
        VariableMapper origVarMapper = ctx.getVariableMapper();
        ctx.setVariableMapper((VariableMapper)new VariableMapperWrapper(origVarMapper));
        try {
            Integer idx;
            Object objValue;
            this.nextHandler.apply(ctx, null);
            ValueExpression ve = this.value != null ? this.value.getValueExpression(ctx, Object.class) : null;
            Object object = objValue = ve != null ? ve.getValue((ELContext)ctx) : null;
            if (objValue == null) {
                return;
            }
            int size = 0;
            if (objValue instanceof List) {
                size = ((List)objValue).size();
            } else if (objValue.getClass().isArray()) {
                size = ((Object[])objValue).length;
            }
            if (this.name == null) {
                return;
            }
            ExpressionFactory exprFactory = ctx.getFacesContext().getApplication().getExpressionFactory();
            String strName = this.name.getValue(ctx);
            String uniqueId = "a" + UUID.randomUUID().toString().replaceAll("-", "");
            ctx.getVariableMapper().setVariable(uniqueId, ve);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                if (strName != null && strName.length() != 0) {
                    sb.append("#{");
                    sb.append(uniqueId);
                    sb.append("[");
                    sb.append(i);
                    sb.append("]}");
                    ctx.getVariableMapper().setVariable(strName, exprFactory.createValueExpression((ELContext)ctx, sb.toString(), Object.class));
                }
                ctx.includeFacelet(parent, path);
                sb.setLength(0);
            }
            if (size > 0 && (idx = (Integer)parent.getAttributes().get("idx")) != null) {
                parent.getAttributes().put("idx", idx + size);
            }
        }
        catch (IOException e) {
            throw new TagAttributeException(this.tag, this.src, "Invalid path : " + path);
        }
        finally {
            ctx.setVariableMapper(origVarMapper);
        }
    }
}

