/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class DataTable004
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<ProgrammingLanguage> progLanguages;
    private ProgrammingLanguage selectedProgLanguage;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
    }

    public void onRowSelect(SelectEvent<ProgrammingLanguage> event) {
        TestUtils.addMessage((String)"ProgrammingLanguage Selected", (String)(((ProgrammingLanguage)event.getObject()).getId() + " - " + ((ProgrammingLanguage)event.getObject()).getName()));
    }

    public void onRowUnselect(UnselectEvent<ProgrammingLanguage> event) {
        TestUtils.addMessage((String)"ProgrammingLanguage Unselected", (String)(((ProgrammingLanguage)event.getObject()).getId() + " - " + ((ProgrammingLanguage)event.getObject()).getName()));
    }

    public void unselectRow() {
        this.selectedProgLanguage = null;
        TestUtils.addMessage((String)"ProgrammingLanguage unselected via backing bean", (String)"");
    }

    public void submit() {
        if (this.selectedProgLanguage != null) {
            TestUtils.addMessage((String)"Selected ProgrammingLanguage", (String)(this.selectedProgLanguage.getId() + " - " + this.selectedProgLanguage.getName()));
        } else {
            TestUtils.addMessage((String)"NO ProgrammingLanguage selected", (String)"");
        }
    }

    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    public ProgrammingLanguage getSelectedProgLanguage() {
        return this.selectedProgLanguage;
    }

    public ProgrammingLanguageService getService() {
        return this.service;
    }

    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    public void setSelectedProgLanguage(ProgrammingLanguage selectedProgLanguage) {
        this.selectedProgLanguage = selectedProgLanguage;
    }

    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable004)) {
            return false;
        }
        DataTable004 other = (DataTable004)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        ProgrammingLanguage this$selectedProgLanguage = this.getSelectedProgLanguage();
        ProgrammingLanguage other$selectedProgLanguage = other.getSelectedProgLanguage();
        if (this$selectedProgLanguage == null ? other$selectedProgLanguage != null : !this$selectedProgLanguage.equals(other$selectedProgLanguage)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable004;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        ProgrammingLanguage $selectedProgLanguage = this.getSelectedProgLanguage();
        result = result * 59 + ($selectedProgLanguage == null ? 43 : $selectedProgLanguage.hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable004(progLanguages=" + this.getProgLanguages() + ", selectedProgLanguage=" + this.getSelectedProgLanguage() + ", service=" + this.getService() + ")";
    }
}

